/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.tiles.IConnectorTile;
import mcjty.xnet.modules.cables.CableSetup;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.modules.facade.MimicBlockSupport;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.setup.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ConnectorTileEntity
extends GenericTileEntity
implements IFacadeSupport,
IConnectorTile {
    public static final String CMD_ENABLE = "connector.enable";
    public static final Key<Integer> PARAM_FACING = new Key("facing", Type.INTEGER);
    public static final Key<Boolean> PARAM_ENABLED = new Key("enabled", Type.BOOLEAN);
    private final MimicBlockSupport mimicBlockSupport = new MimicBlockSupport();
    private int energy = 0;
    private int[] inputFromSide = new int[]{0, 0, 0, 0, 0, 0};
    private String name = "";
    private int pulseCounter;
    private int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    private byte enabled = (byte)63;
    private final LazyOptional<SidedHandler>[] sidedStorages;
    private final Block[] cachedNeighbours = new Block[OrientationTools.DIRECTION_VALUES.length];
    public static final Key<String> VALUE_NAME = new Key("name", Type.STRING);
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Connector").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)CableSetup.CONTAINER_CONNECTOR.get(), windowId.intValue(), (ContainerFactory)EmptyContainer.CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)));

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_NAME, this::getConnectorName, this::setConnectorName)};
    }

    public ConnectorTileEntity() {
        this((TileEntityType)CableSetup.TYPE_CONNECTOR.get());
    }

    protected ConnectorTileEntity(TileEntityType<?> type) {
        super(type);
        this.sidedStorages = new LazyOptional[OrientationTools.DIRECTION_VALUES.length];
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            this.sidedStorages[direction.ordinal()] = LazyOptional.of(() -> this.createSidedHandler(direction));
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        if (this.field_145850_b.field_72995_K) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public int getPowerOut(Direction side) {
        return this.powerOut[side.ordinal()];
    }

    public void setPowerOut(Direction side, int powerOut) {
        if (powerOut > 15) {
            powerOut = 15;
        }
        if (this.powerOut[side.ordinal()] == powerOut) {
            return;
        }
        this.powerOut[side.ordinal()] = powerOut;
        this.func_70296_d();
        this.field_145850_b.func_190524_a(this.field_174879_c.func_177972_a(side), this.func_195044_w().func_177230_c(), this.field_174879_c);
    }

    public void setEnabled(Direction direction, boolean e) {
        this.enabled = e ? (byte)(this.enabled | 1 << direction.ordinal()) : (byte)(this.enabled & ~(1 << direction.ordinal()));
        this.markDirtyClient();
    }

    public boolean isEnabled(Direction direction) {
        return (this.enabled & 1 << direction.ordinal()) != 0;
    }

    @Override
    public BlockState getMimicBlock() {
        return this.mimicBlockSupport.getMimicBlock();
    }

    public void setMimicBlock(BlockState mimicBlock) {
        this.mimicBlockSupport.setMimicBlock(mimicBlock);
        this.markDirtyClient();
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel == 0 && powered > 0) {
            ++this.pulseCounter;
        }
        super.setPowerInput(powered);
    }

    public int getPulseCounter() {
        return this.pulseCounter;
    }

    public void possiblyMarkNetworkDirty(@Nonnull BlockPos neighbor) {
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            if (!this.func_174877_v().func_177972_a(facing).equals((Object)neighbor)) continue;
            Block newblock = this.field_145850_b.func_180495_p(neighbor).func_177230_c();
            if (newblock != this.cachedNeighbours[facing.ordinal()]) {
                this.cachedNeighbours[facing.ordinal()] = newblock;
                WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
                worldBlob.markNetworkDirty(worldBlob.getNetworkAt(this.func_174877_v()));
            }
            return;
        }
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.energy = tagCompound.func_74762_e("energy");
        this.inputFromSide = tagCompound.func_74759_k("inputs");
        if (this.inputFromSide.length != 6) {
            this.inputFromSide = new int[]{0, 0, 0, 0, 0, 0};
        }
        this.mimicBlockSupport.readFromNBT(tagCompound);
        this.pulseCounter = tagCompound.func_74762_e("pulse");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.func_74771_c("p" + i);
        }
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.name = info.func_74779_i("name");
        this.enabled = info.func_74764_b("enabled") ? info.func_74771_c("enabled") : (byte)63;
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("energy", this.energy);
        tagCompound.func_74783_a("inputs", this.inputFromSide);
        this.mimicBlockSupport.writeToNBT(tagCompound);
        tagCompound.func_74768_a("pulse", this.pulseCounter);
        for (int i = 0; i < 6; ++i) {
            tagCompound.func_74774_a("p" + i, (byte)this.powerOut[i]);
        }
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74778_a("name", this.name);
        info.func_74774_a("enabled", this.enabled);
    }

    public void setConnectorName(String n) {
        this.name = n;
        this.markDirtyClient();
    }

    public String getConnectorName() {
        return this.name;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        if (this.energy != energy) {
            if (energy < 0) {
                energy = 0;
            }
            this.energy = energy;
            this.markDirtyQuick();
        }
    }

    public void setEnergyInputFrom(Direction from, int rate) {
        if (this.inputFromSide[from.ordinal()] != rate) {
            this.inputFromSide[from.ordinal()] = rate;
            this.markDirtyQuick();
        }
    }

    public int getMaxEnergy() {
        return (Integer)Config.maxRfConnector.get();
    }

    private int receiveEnergyInternal(Direction from, int maxReceive, boolean simulate) {
        if (from == null) {
            return 0;
        }
        int m = this.inputFromSide[from.ordinal()];
        if (m > 0) {
            int toreceive = Math.min(maxReceive, m);
            int newenergy = this.energy + toreceive;
            if (newenergy > this.getMaxEnergy()) {
                toreceive -= newenergy - this.getMaxEnergy();
                newenergy = this.getMaxEnergy();
            }
            if (!simulate && this.energy != newenergy) {
                this.energy = newenergy;
                this.inputFromSide[from.ordinal()] = 0;
                this.markDirtyQuick();
            }
            return toreceive;
        }
        return 0;
    }

    private int getEnergyStoredInternal() {
        return this.energy;
    }

    private int getMaxEnergyStoredInternal() {
        return this.getMaxEnergy();
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(GenericCableBlock.FACADEID, (Object)this.getMimicBlock()).build();
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_ENABLE.equals(command)) {
            int f = (Integer)params.get(PARAM_FACING);
            boolean e = (Boolean)params.get(PARAM_ENABLED);
            this.setEnabled(OrientationTools.DIRECTION_VALUES[f], e);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            if (side == null) {
                return LazyOptional.empty();
            }
            return this.sidedStorages[side.ordinal()].cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private SidedHandler createSidedHandler(Direction facing) {
        return new SidedHandler(facing);
    }

    class SidedHandler
    implements IEnergyStorage {
        private final Direction facing;

        public SidedHandler(Direction facing) {
            this.facing = facing;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return ConnectorTileEntity.this.receiveEnergyInternal(this.facing, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return ConnectorTileEntity.this.getEnergyStoredInternal();
        }

        public int getMaxEnergyStored() {
            return ConnectorTileEntity.this.getMaxEnergyStoredInternal();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

