/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.modules.facade.blocks.FacadeBlock;
import mcjty.xnet.setup.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class RenderWorldLastEventHandler {
    public static void tick(RenderWorldLastEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack heldItem = mc.field_71439_g.func_184586_b(Hand.MAIN_HAND);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof BlockItem && ((BlockItem)heldItem.func_77973_b()).func_179223_d() instanceof GenericCableBlock) {
            RenderWorldLastEventHandler.renderCables(evt, mc);
        }
    }

    private static void renderCables(RenderWorldLastEvent evt, Minecraft mc) {
        ClientPlayerEntity p = mc.field_71439_g;
        MatrixStack matrixStack = evt.getMatrixStack();
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(CustomRenderTypes.OVERLAY_LINES);
        ClientWorld world = mc.field_71441_e;
        matrixStack.func_227860_a_();
        Vec3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        Matrix4f positionMatrix = matrixStack.func_227866_c_().func_227870_a_();
        for (int dx = -20; dx <= 20; ++dx) {
            for (int dy = -20; dy <= 20; ++dy) {
                for (int dz = -20; dz <= 20; ++dz) {
                    BlockPos c = p.func_180425_c().func_177982_a(dx, dy, dz);
                    BlockState state = world.func_180495_p(c);
                    Block block = state.func_177230_c();
                    if (!(block instanceof FacadeBlock) && !(block instanceof ConnectorBlock) && !(block instanceof GenericCableBlock)) continue;
                    TileEntity te = world.func_175625_s(c);
                    if (te instanceof IFacadeSupport) {
                        BlockState facadeId = ((IFacadeSupport)te).getMimicBlock();
                        if (!(((Boolean)Config.showNonFacadedCablesWhileSneaking.get()).booleanValue() && p.func_225608_bj_() || facadeId != null || block instanceof FacadeBlock)) {
                            continue;
                        }
                    } else if (!((Boolean)Config.showNonFacadedCablesWhileSneaking.get()).booleanValue() || !p.func_225608_bj_()) continue;
                    CableColor color = (CableColor)((Object)state.func_177229_b(GenericCableBlock.COLOR));
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    switch (color) {
                        case BLUE: {
                            r = 0.4f;
                            g = 0.4f;
                            b = 1.0f;
                            break;
                        }
                        case RED: {
                            r = 1.0f;
                            g = 0.4f;
                            b = 0.4f;
                            break;
                        }
                        case YELLOW: {
                            r = 1.0f;
                            g = 1.0f;
                            b = 0.4f;
                            break;
                        }
                        case GREEN: {
                            r = 0.4f;
                            g = 1.0f;
                            b = 0.4f;
                            break;
                        }
                        case ROUTING: {
                            r = 0.7f;
                            g = 0.7f;
                            b = 0.7f;
                        }
                    }
                    List<Rect> quads = RenderWorldLastEventHandler.getQuads(state);
                    for (Rect quad : quads) {
                        RenderWorldLastEventHandler.renderRect(builder, positionMatrix, quad, c, r, g, b, 0.5f);
                    }
                }
            }
        }
        matrixStack.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(CustomRenderTypes.OVERLAY_LINES);
    }

    private static Vec3d v(double x, double y, double z) {
        return new Vec3d(x, y, z);
    }

    private static List<Rect> getQuads(BlockState state) {
        ConnectorType north = (ConnectorType)((Object)state.func_177229_b(GenericCableBlock.NORTH));
        ConnectorType south = (ConnectorType)((Object)state.func_177229_b(GenericCableBlock.SOUTH));
        ConnectorType west = (ConnectorType)((Object)state.func_177229_b(GenericCableBlock.WEST));
        ConnectorType east = (ConnectorType)((Object)state.func_177229_b(GenericCableBlock.EAST));
        ConnectorType up = (ConnectorType)((Object)state.func_177229_b(GenericCableBlock.UP));
        ConnectorType down = (ConnectorType)((Object)state.func_177229_b(GenericCableBlock.DOWN));
        ArrayList<Rect> quads = new ArrayList<Rect>();
        double o = 0.4;
        double p = 0.1;
        double q = 0.2;
        if (up == ConnectorType.CABLE) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, 1.0, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0, 1.0 - o)));
        } else if (up == ConnectorType.BLOCK) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, 1.0 - p, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - p, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - p, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - p, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - p, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - p, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - p, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - p, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - q, 1.0 - p, q), RenderWorldLastEventHandler.v(1.0 - q, 1.0, q), RenderWorldLastEventHandler.v(1.0 - q, 1.0, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - p, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - p, 1.0 - q), RenderWorldLastEventHandler.v(q, 1.0, 1.0 - q), RenderWorldLastEventHandler.v(q, 1.0, q), RenderWorldLastEventHandler.v(q, 1.0 - p, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0, q), RenderWorldLastEventHandler.v(1.0 - q, 1.0, q), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - p, q), RenderWorldLastEventHandler.v(q, 1.0 - p, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - p, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - p, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 1.0, 1.0 - q), RenderWorldLastEventHandler.v(q, 1.0, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - p, q), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - p, q), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - p, 1.0 - q), RenderWorldLastEventHandler.v(q, 1.0 - p, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0, q), RenderWorldLastEventHandler.v(q, 1.0, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 1.0, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 1.0, q)));
        } else {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o)));
        }
        if (down == ConnectorType.CABLE) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 0.0, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 0.0, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(o, 0.0, o), RenderWorldLastEventHandler.v(o, 0.0, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, 0.0, o), RenderWorldLastEventHandler.v(o, 0.0, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 0.0, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 0.0, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, 1.0 - o)));
        } else if (down == ConnectorType.BLOCK) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, p, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, p, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(o, p, o), RenderWorldLastEventHandler.v(o, p, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, p, o), RenderWorldLastEventHandler.v(o, p, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, p, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, p, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - q, 0.0, q), RenderWorldLastEventHandler.v(1.0 - q, p, q), RenderWorldLastEventHandler.v(1.0 - q, p, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 0.0, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 0.0, 1.0 - q), RenderWorldLastEventHandler.v(q, p, 1.0 - q), RenderWorldLastEventHandler.v(q, p, q), RenderWorldLastEventHandler.v(q, 0.0, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, p, q), RenderWorldLastEventHandler.v(1.0 - q, p, q), RenderWorldLastEventHandler.v(1.0 - q, 0.0, q), RenderWorldLastEventHandler.v(q, 0.0, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 0.0, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 0.0, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, p, 1.0 - q), RenderWorldLastEventHandler.v(q, p, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, p, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, p, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, p, q), RenderWorldLastEventHandler.v(q, p, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 0.0, 1.0 - q), RenderWorldLastEventHandler.v(q, 0.0, q), RenderWorldLastEventHandler.v(1.0 - q, 0.0, q), RenderWorldLastEventHandler.v(1.0 - q, 0.0, 1.0 - q)));
        } else {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, 1.0 - o)));
        }
        if (east == ConnectorType.CABLE) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0, o, o), RenderWorldLastEventHandler.v(1.0, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o)));
        } else if (east == ConnectorType.BLOCK) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - p, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, o, o), RenderWorldLastEventHandler.v(1.0 - p, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - p, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - p, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(1.0, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(1.0, 1.0 - q, q), RenderWorldLastEventHandler.v(1.0 - p, 1.0 - q, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, q, q), RenderWorldLastEventHandler.v(1.0, q, q), RenderWorldLastEventHandler.v(1.0, q, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - p, q, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, 1.0 - q, q), RenderWorldLastEventHandler.v(1.0, 1.0 - q, q), RenderWorldLastEventHandler.v(1.0, q, q), RenderWorldLastEventHandler.v(1.0 - p, q, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, q, 1.0 - q), RenderWorldLastEventHandler.v(1.0, q, 1.0 - q), RenderWorldLastEventHandler.v(1.0, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - p, 1.0 - q, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, q, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - p, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - p, 1.0 - q, q), RenderWorldLastEventHandler.v(1.0 - p, q, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0, q, 1.0 - q), RenderWorldLastEventHandler.v(1.0, q, q), RenderWorldLastEventHandler.v(1.0, 1.0 - q, q), RenderWorldLastEventHandler.v(1.0, 1.0 - q, 1.0 - q)));
        } else {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o)));
        }
        if (west == ConnectorType.CABLE) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(0.0, 1.0 - o, o), RenderWorldLastEventHandler.v(0.0, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(0.0, o, 1.0 - o), RenderWorldLastEventHandler.v(0.0, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(0.0, o, o), RenderWorldLastEventHandler.v(0.0, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(0.0, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(0.0, o, 1.0 - o)));
        } else if (west == ConnectorType.BLOCK) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(p, 1.0 - o, o), RenderWorldLastEventHandler.v(p, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(p, o, 1.0 - o), RenderWorldLastEventHandler.v(p, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(p, o, o), RenderWorldLastEventHandler.v(p, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(p, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(p, o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(0.0, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(p, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(p, 1.0 - q, q), RenderWorldLastEventHandler.v(0.0, 1.0 - q, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(0.0, q, q), RenderWorldLastEventHandler.v(p, q, q), RenderWorldLastEventHandler.v(p, q, 1.0 - q), RenderWorldLastEventHandler.v(0.0, q, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(0.0, 1.0 - q, q), RenderWorldLastEventHandler.v(p, 1.0 - q, q), RenderWorldLastEventHandler.v(p, q, q), RenderWorldLastEventHandler.v(0.0, q, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(0.0, q, 1.0 - q), RenderWorldLastEventHandler.v(p, q, 1.0 - q), RenderWorldLastEventHandler.v(p, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(0.0, 1.0 - q, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(p, q, q), RenderWorldLastEventHandler.v(p, 1.0 - q, q), RenderWorldLastEventHandler.v(p, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(p, q, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(0.0, q, q), RenderWorldLastEventHandler.v(0.0, q, 1.0 - q), RenderWorldLastEventHandler.v(0.0, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(0.0, 1.0 - q, q)));
        } else {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, o, o)));
        }
        if (north == ConnectorType.CABLE) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 0.0), RenderWorldLastEventHandler.v(o, 1.0 - o, 0.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 0.0), RenderWorldLastEventHandler.v(1.0 - o, o, 0.0), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(o, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, 0.0), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 0.0), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, 0.0), RenderWorldLastEventHandler.v(o, o, 0.0)));
        } else if (north == ConnectorType.BLOCK) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, p), RenderWorldLastEventHandler.v(o, 1.0 - o, p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, p), RenderWorldLastEventHandler.v(1.0 - o, o, p), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(o, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, p), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, p), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, p), RenderWorldLastEventHandler.v(o, o, p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - q, p), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, p), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 0.0), RenderWorldLastEventHandler.v(q, 1.0 - q, 0.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, q, 0.0), RenderWorldLastEventHandler.v(1.0 - q, q, 0.0), RenderWorldLastEventHandler.v(1.0 - q, q, p), RenderWorldLastEventHandler.v(q, q, p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - q, q, 0.0), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 0.0), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, p), RenderWorldLastEventHandler.v(1.0 - q, q, p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, q, p), RenderWorldLastEventHandler.v(q, 1.0 - q, p), RenderWorldLastEventHandler.v(q, 1.0 - q, 0.0), RenderWorldLastEventHandler.v(q, q, 0.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, q, p), RenderWorldLastEventHandler.v(1.0 - q, q, p), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, p), RenderWorldLastEventHandler.v(q, 1.0 - q, p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, q, 0.0), RenderWorldLastEventHandler.v(q, 1.0 - q, 0.0), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 0.0), RenderWorldLastEventHandler.v(1.0 - q, q, 0.0)));
        } else {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(o, o, o)));
        }
        if (south == ConnectorType.CABLE) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0), RenderWorldLastEventHandler.v(o, o, 1.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, 1.0 - o)));
        } else if (south == ConnectorType.BLOCK) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - p), RenderWorldLastEventHandler.v(o, o, 1.0 - p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - p), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - p), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - q, 1.0), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 1.0), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 1.0 - p), RenderWorldLastEventHandler.v(q, 1.0 - q, 1.0 - p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, q, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - q, q, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - q, q, 1.0), RenderWorldLastEventHandler.v(q, q, 1.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - q, q, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 1.0), RenderWorldLastEventHandler.v(1.0 - q, q, 1.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, q, 1.0), RenderWorldLastEventHandler.v(q, 1.0 - q, 1.0), RenderWorldLastEventHandler.v(q, 1.0 - q, 1.0 - p), RenderWorldLastEventHandler.v(q, q, 1.0 - p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - q, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - q, q, 1.0 - p), RenderWorldLastEventHandler.v(q, q, 1.0 - p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - q, 1.0), RenderWorldLastEventHandler.v(q, q, 1.0), RenderWorldLastEventHandler.v(1.0 - q, q, 1.0), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 1.0)));
        } else {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o)));
        }
        return quads;
    }

    public static void renderRect(IVertexBuilder buffer, Matrix4f positionMatrix, Rect rect, BlockPos p, float r, float g, float b, float a) {
        buffer.func_227888_a_(positionMatrix, (float)((double)p.func_177958_n() + rect.v1.field_72450_a), (float)((double)p.func_177956_o() + rect.v1.field_72448_b), (float)((double)p.func_177952_p() + rect.v1.field_72449_c)).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, (float)((double)p.func_177958_n() + rect.v2.field_72450_a), (float)((double)p.func_177956_o() + rect.v2.field_72448_b), (float)((double)p.func_177952_p() + rect.v2.field_72449_c)).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, (float)((double)p.func_177958_n() + rect.v2.field_72450_a), (float)((double)p.func_177956_o() + rect.v2.field_72448_b), (float)((double)p.func_177952_p() + rect.v2.field_72449_c)).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, (float)((double)p.func_177958_n() + rect.v3.field_72450_a), (float)((double)p.func_177956_o() + rect.v3.field_72448_b), (float)((double)p.func_177952_p() + rect.v3.field_72449_c)).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, (float)((double)p.func_177958_n() + rect.v3.field_72450_a), (float)((double)p.func_177956_o() + rect.v3.field_72448_b), (float)((double)p.func_177952_p() + rect.v3.field_72449_c)).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, (float)((double)p.func_177958_n() + rect.v4.field_72450_a), (float)((double)p.func_177956_o() + rect.v4.field_72448_b), (float)((double)p.func_177952_p() + rect.v4.field_72449_c)).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, (float)((double)p.func_177958_n() + rect.v4.field_72450_a), (float)((double)p.func_177956_o() + rect.v4.field_72448_b), (float)((double)p.func_177952_p() + rect.v4.field_72449_c)).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(positionMatrix, (float)((double)p.func_177958_n() + rect.v1.field_72450_a), (float)((double)p.func_177956_o() + rect.v1.field_72448_b), (float)((double)p.func_177952_p() + rect.v1.field_72449_c)).func_227885_a_(r, g, b, a).func_181675_d();
    }

    private static class Rect {
        public Vec3d v1;
        public Vec3d v2;
        public Vec3d v3;
        public Vec3d v4;

        public Rect(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.v4 = v4;
        }
    }
}

