/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.DataHandlerUtils;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.BasicInfusionTank;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class StorageUtils {
    public static void addStoredEnergy(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip, boolean showMissingCap) {
        StorageUtils.addStoredEnergy(stack, tooltip, showMissingCap, MekanismLang.STORED_ENERGY);
    }

    public static void addStoredEnergy(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip, boolean showMissingCap, ILangEntry langEntry) {
        if (Capabilities.STRICT_ENERGY_CAPABILITY != null) {
            Optional capability = MekanismUtils.toOptional(stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY));
            if (capability.isPresent()) {
                IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)capability.get();
                int energyContainerCount = energyHandlerItem.getEnergyContainerCount();
                for (int container = 0; container < energyContainerCount; ++container) {
                    tooltip.add(langEntry.translateColored(EnumColor.BRIGHT_GREEN, new Object[]{EnumColor.GRAY, EnergyDisplay.of(energyHandlerItem.getEnergy(container), energyHandlerItem.getMaxEnergy(container))}));
                }
            } else if (showMissingCap) {
                tooltip.add(langEntry.translateColored(EnumColor.BRIGHT_GREEN, new Object[]{EnumColor.GRAY, EnergyDisplay.ZERO}));
            }
        }
    }

    public static void addStoredGas(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip, boolean showMissingCap) {
        StorageUtils.addStoredGas(stack, tooltip, showMissingCap, MekanismLang.NO_GAS, stored -> {
            if (stored.isEmpty()) {
                return MekanismLang.NO_GAS.translate(new Object[0]);
            }
            return MekanismLang.STORED.translate(stored, stored.getAmount());
        });
    }

    public static void addStoredGas(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip, boolean showMissingCap, ILangEntry emptyLangEntry, Function<GasStack, ITextComponent> storedFunction) {
        if (Capabilities.GAS_HANDLER_CAPABILITY != null) {
            Optional capability = MekanismUtils.toOptional(stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY));
            if (capability.isPresent()) {
                IGasHandler gasHandlerItem = (IGasHandler)capability.get();
                int tanks = gasHandlerItem.getGasTankCount();
                for (int tank = 0; tank < tanks; ++tank) {
                    tooltip.add(storedFunction.apply(gasHandlerItem.getGasInTank(tank)));
                }
            } else if (showMissingCap) {
                tooltip.add((ITextComponent)emptyLangEntry.translate(new Object[0]));
            }
        }
    }

    @Nonnull
    public static FluidStack getStoredFluidFromNBT(ItemStack stack) {
        BasicFluidTank tank = BasicFluidTank.create(Integer.MAX_VALUE, null);
        DataHandlerUtils.readTanks(Collections.singletonList(tank), ItemDataUtils.getList(stack, "FluidTanks"));
        return tank.getFluid();
    }

    @Nonnull
    public static GasStack getStoredGasFromNBT(ItemStack stack) {
        BasicGasTank tank = BasicGasTank.create(Long.MAX_VALUE, null);
        DataHandlerUtils.readTanks(Collections.singletonList(tank), ItemDataUtils.getList(stack, "GasTanks"));
        return (GasStack)tank.getStack();
    }

    @Nonnull
    public static InfusionStack getStoredInfusionFromNBT(ItemStack stack) {
        BasicInfusionTank tank = BasicInfusionTank.create(Long.MAX_VALUE, null);
        DataHandlerUtils.readTanks(Collections.singletonList(tank), ItemDataUtils.getList(stack, "InfusionTanks"));
        return (InfusionStack)tank.getStack();
    }

    public static FloatingLong getStoredEnergyFromNBT(ItemStack stack) {
        BasicEnergyContainer container = BasicEnergyContainer.create(FloatingLong.MAX_VALUE, null);
        DataHandlerUtils.readContainers(Collections.singletonList(container), ItemDataUtils.getList(stack, "EnergyContainers"));
        return container.getEnergy();
    }

    public static ItemStack getFilledEnergyVariant(ItemStack toFill, FloatingLong capacity) {
        BasicEnergyContainer container = BasicEnergyContainer.create(capacity, null);
        container.setEnergy(capacity);
        ItemDataUtils.setList(toFill, "EnergyContainers", DataHandlerUtils.writeContainers(Collections.singletonList(container)));
        return toFill;
    }

    @Nullable
    public static IEnergyContainer getEnergyContainer(ItemStack stack, int container) {
        IStrictEnergyHandler energyHandlerItem;
        Optional energyCapability = MekanismUtils.toOptional(stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY));
        if (energyCapability.isPresent() && (energyHandlerItem = (IStrictEnergyHandler)energyCapability.get()) instanceof IMekanismStrictEnergyHandler) {
            return ((IMekanismStrictEnergyHandler)energyHandlerItem).getEnergyContainer(container, null);
        }
        return null;
    }

    public static double getDurabilityForDisplay(ItemStack stack) {
        Optional energyCapability;
        Optional fluidCapability;
        Optional infusionCapability;
        if (Capabilities.GAS_HANDLER_CAPABILITY == null || Capabilities.INFUSION_HANDLER_CAPABILITY == null || CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY == null || Capabilities.STRICT_ENERGY_CAPABILITY == null) {
            return 1.0;
        }
        double bestRatio = 0.0;
        Optional gasCapability = MekanismUtils.toOptional(stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY));
        if (gasCapability.isPresent()) {
            IGasHandler gasHandlerItem = (IGasHandler)gasCapability.get();
            int tanks = gasHandlerItem.getGasTankCount();
            for (int tank = 0; tank < tanks; ++tank) {
                bestRatio = Math.max(bestRatio, StorageUtils.getRatio(gasHandlerItem.getGasInTank(tank).getAmount(), gasHandlerItem.getGasTankCapacity(tank)));
            }
        }
        if ((infusionCapability = MekanismUtils.toOptional(stack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY))).isPresent()) {
            IInfusionHandler infusionHandlerItem = (IInfusionHandler)infusionCapability.get();
            int tanks = infusionHandlerItem.getInfusionTankCount();
            for (int tank = 0; tank < tanks; ++tank) {
                bestRatio = Math.max(bestRatio, StorageUtils.getRatio(infusionHandlerItem.getInfusionInTank(tank).getAmount(), infusionHandlerItem.getInfusionTankCapacity(tank)));
            }
        }
        if ((fluidCapability = MekanismUtils.toOptional(stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY))).isPresent()) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)fluidCapability.get();
            int tanks = fluidHandlerItem.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                bestRatio = Math.max(bestRatio, StorageUtils.getRatio(fluidHandlerItem.getFluidInTank(tank).getAmount(), fluidHandlerItem.getTankCapacity(tank)));
            }
        }
        if ((energyCapability = MekanismUtils.toOptional(stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY))).isPresent()) {
            IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)energyCapability.get();
            int containers = energyHandlerItem.getEnergyContainerCount();
            for (int container = 0; container < containers; ++container) {
                bestRatio = Math.max(bestRatio, energyHandlerItem.getEnergy(container).divideToLevel(energyHandlerItem.getMaxEnergy(container)));
            }
        }
        return 1.0 - bestRatio;
    }

    private static double getRatio(long amount, long capacity) {
        return capacity == 0L ? 1.0 : (double)amount / (double)capacity;
    }

    public static void mergeTanks(IExtendedFluidTank tank, IExtendedFluidTank mergeTank) {
        if (tank.isEmpty()) {
            tank.setStack(mergeTank.getFluid());
        } else if (!mergeTank.isEmpty() && tank.isFluidEqual(mergeTank.getFluid())) {
            tank.growStack(mergeTank.getFluidAmount(), Action.EXECUTE);
        }
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void mergeTanks(IChemicalTank<CHEMICAL, STACK> tank, IChemicalTank<CHEMICAL, STACK> mergeTank) {
        if (tank.isEmpty()) {
            tank.setStack(mergeTank.getStack());
        } else if (!mergeTank.isEmpty() && tank.isTypeEqual(mergeTank.getStack())) {
            tank.growStack(mergeTank.getStored(), Action.EXECUTE);
        }
    }

    public static void mergeContainers(IEnergyContainer container, IEnergyContainer mergeContainer) {
        container.setEnergy(container.getEnergy().add(mergeContainer.getEnergy()));
    }

    public static void mergeContainers(IHeatCapacitor capacitor, IHeatCapacitor mergeCapacitor) {
        capacitor.setHeat(capacitor.getHeat() + mergeCapacitor.getHeat());
        if (capacitor instanceof BasicHeatCapacitor) {
            ((BasicHeatCapacitor)capacitor).setHeatCapacity(capacitor.getHeatCapacity() + mergeCapacitor.getHeatCapacity(), false);
        }
    }
}

