/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters.grid;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.VariableCapacityGasTank;
import mekanism.common.distribution.target.GasHandlerTarget;
import mekanism.common.distribution.target.GasTransmitterSaveTarget;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;

public class GasNetwork
extends DynamicNetwork<IGasHandler, GasNetwork, GasStack>
implements IMekanismGasHandler {
    private final List<IGasTank> gasTanks;
    public final VariableCapacityGasTank gasTank;
    @Nonnull
    public Gas lastGas = MekanismAPI.EMPTY_GAS;
    public float gasScale;
    private long prevTransferAmount;

    public GasNetwork() {
        this.gasTank = VariableCapacityGasTank.create(this::getCapacity, BasicGasTank.alwaysTrueBi, BasicGasTank.alwaysTrueBi, BasicGasTank.alwaysTrue, ChemicalAttributeValidator.ALWAYS_ALLOW, (IMekanismGasHandler)this);
        this.gasTanks = Collections.singletonList(this.gasTank);
    }

    public GasNetwork(UUID networkID) {
        super(networkID);
        this.gasTank = VariableCapacityGasTank.create(this::getCapacity, BasicGasTank.alwaysTrueBi, BasicGasTank.alwaysTrueBi, BasicGasTank.alwaysTrue, ChemicalAttributeValidator.ALWAYS_ALLOW, (IMekanismGasHandler)this);
        this.gasTanks = Collections.singletonList(this.gasTank);
    }

    public GasNetwork(Collection<GasNetwork> networks) {
        this();
        for (GasNetwork net : networks) {
            if (net == null) continue;
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.register();
    }

    @Override
    protected void forceScaleUpdate() {
        this.gasScale = !this.gasTank.isEmpty() && this.gasTank.getCapacity() > 0L ? (float)Math.min(1.0, (double)this.gasTank.getStored() / (double)this.gasTank.getCapacity()) : 0.0f;
    }

    @Override
    public void adoptTransmittersAndAcceptorsFrom(GasNetwork net) {
        float oldScale = this.gasScale;
        long oldCapacity = this.getCapacity();
        super.adoptTransmittersAndAcceptorsFrom(net);
        long capacity = this.getCapacity();
        this.gasScale = Math.min(1.0f, capacity == 0L ? 0.0f : (this.gasScale * (float)oldCapacity + net.gasScale * (float)net.capacity) / (float)capacity);
        if (this.isRemote()) {
            if (this.gasTank.isEmpty() && !net.gasTank.isEmpty()) {
                this.gasTank.setStack(net.getBuffer());
                net.gasTank.setEmpty();
            }
        } else {
            if (!net.gasTank.isEmpty()) {
                if (this.gasTank.isEmpty()) {
                    this.gasTank.setStack(net.getBuffer());
                } else if (this.gasTank.isTypeEqual(net.gasTank.getType())) {
                    long amount = net.gasTank.getStored();
                    MekanismUtils.logMismatchedStackSize(this.gasTank.growStack(amount, Action.EXECUTE), amount);
                }
                net.gasTank.setEmpty();
            }
            if (oldScale != this.gasScale) {
                this.needsUpdate = true;
            }
        }
    }

    @Override
    @Nonnull
    public GasStack getBuffer() {
        return ((GasStack)this.gasTank.getStack()).copy();
    }

    @Override
    public void absorbBuffer(IGridTransmitter<IGasHandler, GasNetwork, GasStack> transmitter) {
        GasStack gas = transmitter.getBuffer();
        if (gas.isEmpty()) {
            return;
        }
        if (this.gasTank.isEmpty()) {
            this.gasTank.setStack(gas.copy());
        } else if (gas.isTypeEqual(this.gasTank.getType())) {
            long amount = gas.getAmount();
            MekanismUtils.logMismatchedStackSize(this.gasTank.growStack(amount, Action.EXECUTE), amount);
        }
    }

    @Override
    public void clampBuffer() {
        if (!this.gasTank.isEmpty()) {
            long capacity = this.getCapacity();
            if (this.gasTank.getStored() > capacity) {
                MekanismUtils.logMismatchedStackSize(this.gasTank.setStackSize(capacity, Action.EXECUTE), capacity);
            }
        }
    }

    @Override
    protected void updateSaveShares() {
        super.updateSaveShares();
        int size = this.transmittersSize();
        if (size > 0) {
            GasStack gasType = (GasStack)this.gasTank.getStack();
            Direction side = Direction.NORTH;
            ObjectOpenHashSet saveTargets = new ObjectOpenHashSet(size);
            for (IGridTransmitter transmitter : this.transmitters) {
                GasTransmitterSaveTarget saveTarget = new GasTransmitterSaveTarget(gasType);
                saveTarget.addHandler(side, transmitter);
                saveTargets.add(saveTarget);
            }
            EmitUtils.sendToAcceptors(saveTargets, size, gasType.getAmount(), gasType);
            for (GasTransmitterSaveTarget saveTarget : saveTargets) {
                saveTarget.saveShare(side);
            }
        }
    }

    private long tickEmit(@Nonnull GasStack stack) {
        ObjectOpenHashSet availableAcceptors = new ObjectOpenHashSet();
        int totalHandlers = 0;
        GasStack unitStack = new GasStack(stack, 1L);
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        for (Coord4D coord : this.possibleAcceptors) {
            TileEntity tile;
            EnumSet sides = (EnumSet)this.acceptorDirections.get(coord);
            if (sides == null || sides.isEmpty() || (tile = MekanismUtils.getTileEntity((IWorld)this.getWorld(), (Long2ObjectMap<IChunk>)chunkMap, coord)) == null) continue;
            GasHandlerTarget target = new GasHandlerTarget(stack);
            for (Direction side : sides) {
                CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GAS_HANDLER_CAPABILITY, side).ifPresent(acceptor -> {
                    if (GasUtils.canInsert(acceptor, unitStack)) {
                        target.addHandler(side, acceptor);
                    }
                });
            }
            int curHandlers = target.getHandlers().size();
            if (curHandlers <= 0) continue;
            availableAcceptors.add(target);
            totalHandlers += curHandlers;
        }
        return EmitUtils.sendToAcceptors(availableAcceptors, totalHandlers, stack.getAmount(), stack);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.isRemote()) {
            float scale = this.computeContentScale();
            if (scale != this.gasScale) {
                this.gasScale = scale;
                this.needsUpdate = true;
            }
            if (this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new GasTransferEvent(this, this.lastGas, this.gasScale));
                this.needsUpdate = false;
            }
            if (this.gasTank.isEmpty()) {
                this.prevTransferAmount = 0L;
            } else {
                this.prevTransferAmount = this.tickEmit((GasStack)this.gasTank.getStack());
                MekanismUtils.logMismatchedStackSize(this.gasTank.shrinkStack(this.prevTransferAmount, Action.EXECUTE), this.prevTransferAmount);
            }
        }
    }

    public float computeContentScale() {
        float scale = (float)((double)this.gasTank.getStored() / (double)this.gasTank.getCapacity());
        float ret = Math.max(this.gasScale, scale);
        if (this.prevTransferAmount > 0L && ret < 1.0f) {
            ret = Math.min(1.0f, ret + 0.02f);
        } else if (this.prevTransferAmount <= 0L && ret > 0.0f) {
            ret = Math.max(scale, ret - 0.02f);
        }
        return ret;
    }

    public long getPrevTransferAmount() {
        return this.prevTransferAmount;
    }

    public String toString() {
        return "[GasNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public ITextComponent getNeededInfo() {
        return TextComponentUtil.build(this.gasTank.getNeeded());
    }

    @Override
    public ITextComponent getStoredInfo() {
        if (this.gasTank.isEmpty()) {
            return MekanismLang.NONE.translate(new Object[0]);
        }
        return MekanismLang.NETWORK_MB_STORED.translate(this.gasTank.getStack(), this.gasTank.getStored());
    }

    @Override
    public ITextComponent getFlowInfo() {
        return MekanismLang.NETWORK_MB_PER_TICK.translate(this.prevTransferAmount);
    }

    @Override
    public boolean isCompatibleWith(GasNetwork other) {
        return super.isCompatibleWith(other) && (this.gasTank.isEmpty() || other.gasTank.isEmpty() || this.gasTank.isTypeEqual(other.gasTank.getType()));
    }

    @Override
    public boolean compatibleWithBuffer(@Nonnull GasStack buffer) {
        return super.compatibleWithBuffer(buffer) && (this.gasTank.isEmpty() || buffer.isEmpty() || this.gasTank.isTypeEqual(buffer));
    }

    @Override
    public ITextComponent getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.GAS_NETWORK, this.transmitters.size(), this.possibleAcceptors.size());
    }

    @Override
    @Nonnull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Override
    public void onContentsChanged() {
        this.updateSaveShares = true;
        Gas type = (Gas)this.gasTank.getType();
        if (!type.isEmptyType() && this.lastGas != type) {
            this.lastGas = type;
            this.needsUpdate = true;
        }
    }

    public void setLastGas(@Nonnull Gas gas) {
        if (gas.isEmptyType()) {
            this.gasTank.setEmpty();
        } else {
            this.lastGas = gas;
            this.gasTank.setStack(this.lastGas.getGasStack(1L));
        }
    }

    public static class GasTransferEvent
    extends Event {
        public final GasNetwork gasNetwork;
        public final Gas transferType;
        public final float gasScale;

        public GasTransferEvent(GasNetwork network, Gas type, float scale) {
            this.gasNetwork = network;
            this.transferType = type;
            this.gasScale = scale;
        }
    }
}

