/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.AlloyTier;
import mekanism.api.tier.BaseTier;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.proxy.ProxyFluidHandler;
import mekanism.common.capabilities.resolver.advanced.AdvancedCapabilityResolver;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.PipeTier;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.transmitters.grid.FluidNetwork;
import mekanism.common.upgrade.transmitter.MechanicalPipeUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityMechanicalPipe
extends TileEntityTransmitter<IFluidHandler, FluidNetwork, FluidStack>
implements IMekanismFluidHandler {
    public final PipeTier tier;
    @Nonnull
    public FluidStack lastWrite = FluidStack.EMPTY;
    private final List<IExtendedFluidTank> tanks;
    public BasicFluidTank buffer;

    public TileEntityMechanicalPipe(IBlockProvider blockProvider) {
        super(blockProvider);
        this.tier = Attribute.getTier(blockProvider.getBlock(), PipeTier.class);
        this.buffer = BasicFluidTank.create(MathUtils.clampToInt(this.getCapacity()), BasicFluidTank.alwaysFalse, BasicFluidTank.alwaysTrue, this);
        this.tanks = Collections.singletonList(this.buffer);
        this.addCapabilityResolver(AdvancedCapabilityResolver.readOnly(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this, () -> new ProxyFluidHandler(this, null, null)));
    }

    @Override
    public void func_73660_a() {
        Set<Direction> connections;
        if (!this.isRemote() && !(connections = this.getConnections(TileEntitySidedPipe.ConnectionType.PULL)).isEmpty()) {
            for (IFluidHandler connectedAcceptor : PipeUtils.getConnectedAcceptors(this.func_174877_v(), this.func_145831_w(), connections)) {
                FluidStack bufferWithFallback;
                FluidStack received;
                if (connectedAcceptor == null || (received = (bufferWithFallback = this.getBufferWithFallback()).isEmpty() ? connectedAcceptor.drain(this.getAvailablePull(), IFluidHandler.FluidAction.SIMULATE) : connectedAcceptor.drain(new FluidStack(bufferWithFallback, this.getAvailablePull()), IFluidHandler.FluidAction.SIMULATE)).isEmpty() || !this.takeFluid(received, Action.SIMULATE).isEmpty()) continue;
                FluidStack remainder = this.takeFluid(received, Action.EXECUTE);
                connectedAcceptor.drain(new FluidStack(received, received.getAmount() - remainder.getAmount()), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        super.func_73660_a();
    }

    private int getAvailablePull() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return Math.min(this.tier.getPipePullAmount(), ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).fluidTank.getNeeded());
        }
        return Math.min(this.tier.getPipePullAmount(), this.buffer.getNeeded());
    }

    @Override
    @Nonnull
    public FluidStack insertFluid(int tank, @Nonnull FluidStack stack, @Nullable Direction side, @Nonnull Action action) {
        IExtendedFluidTank fluidTank = this.getFluidTank(tank, side);
        if (fluidTank == null) {
            return stack;
        }
        if (side == null) {
            return fluidTank.insert(stack, action, AutomationType.INTERNAL);
        }
        TileEntitySidedPipe.ConnectionType connectionType = this.getConnectionType(side);
        if (connectionType == TileEntitySidedPipe.ConnectionType.NORMAL || connectionType == TileEntitySidedPipe.ConnectionType.PULL) {
            return fluidTank.insert(stack, action, AutomationType.EXTERNAL);
        }
        return stack;
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        this.lastWrite = nbtTags.func_150297_b("fluid", 10) ? FluidStack.loadFluidStackFromNBT((CompoundNBT)nbtTags.func_74775_l("fluid")) : FluidStack.EMPTY;
        this.buffer.setStack(this.lastWrite);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.lastWrite.isEmpty()) {
            nbtTags.func_82580_o("fluid");
        } else {
            nbtTags.func_218657_a("fluid", (INBT)this.lastWrite.writeToNBT(new CompoundNBT()));
        }
        return nbtTags;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.FLUID;
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.MECHANICAL_PIPE;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, Direction side) {
        if (CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, null).filter(transmitter -> TransmissionType.checkTransmissionType(transmitter, TransmissionType.FLUID)).isPresent()) {
            return false;
        }
        return this.isAcceptorAndListen(tile, side, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    @Override
    public boolean isValidTransmitter(TileEntity tile) {
        TileEntityMechanicalPipe other;
        FluidStack otherBuffer;
        if (!super.isValidTransmitter(tile)) {
            return false;
        }
        if (!(tile instanceof TileEntityMechanicalPipe)) {
            return true;
        }
        FluidStack buffer = this.getBufferWithFallback();
        if (buffer.isEmpty() && this.getTransmitter().hasTransmitterNetwork() && ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).getPrevTransferAmount() > 0) {
            buffer = ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).lastFluid;
        }
        if ((otherBuffer = (other = (TileEntityMechanicalPipe)tile).getBufferWithFallback()).isEmpty() && other.getTransmitter().hasTransmitterNetwork() && ((FluidNetwork)other.getTransmitter().getTransmitterNetwork()).getPrevTransferAmount() > 0) {
            otherBuffer = ((FluidNetwork)other.getTransmitter().getTransmitterNetwork()).lastFluid;
        }
        return buffer.isEmpty() || otherBuffer.isEmpty() || buffer.isFluidEqual(otherBuffer);
    }

    @Override
    public FluidNetwork createNewNetwork() {
        return new FluidNetwork();
    }

    @Override
    public FluidNetwork createNewNetworkWithID(UUID networkID) {
        return new FluidNetwork(networkID);
    }

    @Override
    public FluidNetwork createNetworkByMerging(Collection<FluidNetwork> networks) {
        return new FluidNetwork(networks);
    }

    @Override
    protected boolean canHaveIncompatibleNetworks() {
        return true;
    }

    @Override
    public long getCapacity() {
        return this.tier.getPipeCapacity();
    }

    @Override
    @Nonnull
    public FluidStack getBuffer() {
        return this.buffer.getFluid();
    }

    @Override
    public boolean noBufferOrFallback() {
        return this.getBufferWithFallback().isEmpty();
    }

    @Override
    @Nonnull
    public FluidStack getBufferWithFallback() {
        FluidStack buffer = this.getBuffer();
        if (buffer.isEmpty() && this.getTransmitter().hasTransmitterNetwork()) {
            return ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).getBuffer();
        }
        return buffer;
    }

    @Override
    public void takeShare() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)this.getTransmitter().getTransmitterNetwork();
            if (!network.fluidTank.isEmpty() && !this.lastWrite.isEmpty()) {
                int amount = this.lastWrite.getAmount();
                MekanismUtils.logMismatchedStackSize(network.fluidTank.shrinkStack(amount, Action.EXECUTE), amount);
                this.buffer.setStack(this.lastWrite);
            }
        }
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).getFluidTanks(side);
        }
        return this.tanks;
    }

    @Override
    public void onContentsChanged() {
        this.markDirty(false);
    }

    @Override
    public IFluidHandler getCachedAcceptor(Direction side) {
        return MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)this.getCachedTile(side), CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())).orElse(null);
    }

    @Nonnull
    private FluidStack takeFluid(@Nonnull FluidStack fluid, Action action) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).fluidTank.insert(fluid, action, AutomationType.INTERNAL);
        }
        return this.buffer.insert(fluid, action, AutomationType.INTERNAL);
    }

    @Override
    protected boolean canUpgrade(AlloyTier alloyTier) {
        return alloyTier.getBaseTier().ordinal() == this.tier.getBaseTier().ordinal() + 1;
    }

    @Override
    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        switch (tier) {
            case BASIC: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.BASIC_MECHANICAL_PIPE.getBlock().func_176223_P());
            }
            case ADVANCED: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ADVANCED_MECHANICAL_PIPE.getBlock().func_176223_P());
            }
            case ELITE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ELITE_MECHANICAL_PIPE.getBlock().func_176223_P());
            }
            case ULTIMATE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ULTIMATE_MECHANICAL_PIPE.getBlock().func_176223_P());
            }
        }
        return current;
    }

    @Override
    @Nullable
    protected MechanicalPipeUpgradeData getUpgradeData() {
        return new MechanicalPipeUpgradeData(this.redstoneReactive, this.connectionTypes, this.getBuffer());
    }

    @Override
    protected void parseUpgradeData(@Nonnull TransmitterUpgradeData upgradeData) {
        if (upgradeData instanceof MechanicalPipeUpgradeData) {
            MechanicalPipeUpgradeData data = (MechanicalPipeUpgradeData)upgradeData;
            this.redstoneReactive = data.redstoneReactive;
            this.connectionTypes = data.connectionTypes;
            this.takeFluid(data.contents, Action.EXECUTE);
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        TransmitterImpl transmitter = this.getTransmitter();
        if (transmitter.hasTransmitterNetwork()) {
            updateTag.func_218657_a("fluid", (INBT)((FluidNetwork)transmitter.getTransmitterNetwork()).lastFluid.writeToNBT(new CompoundNBT()));
            updateTag.func_74776_a("scale", ((FluidNetwork)transmitter.getTransmitterNetwork()).fluidScale);
        }
        return updateTag;
    }

    @Override
    protected void handleContentsUpdateTag(@Nonnull FluidNetwork network, @Nonnull CompoundNBT tag) {
        NBTUtils.setFluidStackIfPresent(tag, "fluid", network::setLastFluid);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            network.fluidScale = scale;
        });
    }
}

