/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.SawmillCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.base.ITileComponent;
import mekanism.common.base.ProcessInfo;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.FactoryInputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.upgrade.SawmillUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntitySawingFactory
extends TileEntityFactory<SawmillRecipe> {
    protected IInputHandler<@NonNull ItemStack>[] inputHandlers;
    protected IOutputHandler<@NonNull SawmillRecipe.ChanceOutput>[] outputHandlers;

    public TileEntitySawingFactory(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder) {
        int baseX;
        this.inputHandlers = new IInputHandler[this.tier.processes];
        this.outputHandlers = new IOutputHandler[this.tier.processes];
        this.processInfoSlots = new ProcessInfo[this.tier.processes];
        int n = this.tier == FactoryTier.BASIC ? 55 : (this.tier == FactoryTier.ADVANCED ? 35 : (baseX = this.tier == FactoryTier.ELITE ? 29 : 27));
        int baseXMult = this.tier == FactoryTier.BASIC ? 38 : (this.tier == FactoryTier.ADVANCED ? 26 : 19);
        for (int i = 0; i < this.tier.processes; ++i) {
            int xPos = baseX + i * baseXMult;
            OutputInventorySlot outputSlot = OutputInventorySlot.at(this, xPos, 57);
            OutputInventorySlot secondaryOutputSlot = OutputInventorySlot.at(this, xPos, 77);
            FactoryInputInventorySlot<SawmillRecipe> inputSlot = FactoryInputInventorySlot.create(this, i, outputSlot, secondaryOutputSlot, this, xPos, 13);
            builder.addSlot(inputSlot);
            builder.addSlot(outputSlot);
            builder.addSlot(secondaryOutputSlot);
            this.inputHandlers[i] = InputHelper.getInputHandler(inputSlot);
            this.outputHandlers[i] = OutputHelper.getOutputHandler(outputSlot, (IInventorySlot)secondaryOutputSlot);
            this.processInfoSlots[i] = new ProcessInfo(i, inputSlot, outputSlot, secondaryOutputSlot);
        }
    }

    @Override
    public boolean isValidInputItem(@Nonnull ItemStack stack) {
        return this.containsRecipe(recipe -> recipe.getInput().testType(stack));
    }

    @Override
    public boolean inputProducesOutput(int process, @Nonnull ItemStack fallbackInput, @Nonnull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot, boolean updateCache) {
        ItemStack extra;
        if (outputSlot.isEmpty()) {
            return true;
        }
        CachedRecipe cached = this.getCachedRecipe(process);
        if (cached != null && ((SawmillRecipe)cached.getRecipe()).getInput().testType(fallbackInput)) {
            return true;
        }
        ItemStack output = outputSlot.getStack();
        SawmillRecipe foundRecipe = (SawmillRecipe)this.findFirstRecipe(arg_0 -> TileEntitySawingFactory.lambda$inputProducesOutput$1(fallbackInput, output, extra = secondaryOutputSlot == null ? ItemStack.field_190927_a : secondaryOutputSlot.getStack(), arg_0));
        if (foundRecipe == null) {
            return false;
        }
        if (updateCache) {
            CachedRecipe<SawmillRecipe> newCachedRecipe = this.createNewCachedRecipe(foundRecipe, process);
            if (newCachedRecipe == null) {
                return false;
            }
            this.updateCachedRecipe(newCachedRecipe, process);
        }
        return true;
    }

    @Override
    @Nonnull
    public MekanismRecipeType<SawmillRecipe> getRecipeType() {
        return MekanismRecipeType.SAWING;
    }

    @Override
    @Nullable
    public SawmillRecipe getRecipe(int cacheIndex) {
        ItemStack stack = this.inputHandlers[cacheIndex].getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        return (SawmillRecipe)this.findFirstRecipe(recipe -> recipe.test(stack));
    }

    @Override
    public CachedRecipe<SawmillRecipe> createNewCachedRecipe(@Nonnull SawmillRecipe recipe, int cacheIndex) {
        return new SawmillCachedRecipe(recipe, this.inputHandlers[cacheIndex], this.outputHandlers[cacheIndex]).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof SawmillUpgradeData) {
            int i;
            SawmillUpgradeData data = (SawmillUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.setStack(data.energySlot.getStack());
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                ((IInventorySlot)this.inputSlots.get(i)).setStack(((IInventorySlot)data.inputSlots.get(i)).getStack());
            }
            for (i = 0; i < data.outputSlots.size(); ++i) {
                ((IInventorySlot)this.outputSlots.get(i)).setStack(((IInventorySlot)data.outputSlots.get(i)).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public SawmillUpgradeData getUpgradeData() {
        return new SawmillUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    private static /* synthetic */ boolean lambda$inputProducesOutput$1(ItemStack fallbackInput, ItemStack output, ItemStack extra, SawmillRecipe recipe) {
        SawmillRecipe.ChanceOutput chanceOutput;
        if (recipe.getInput().testType(fallbackInput) && ItemHandlerHelper.canItemStacksStack((ItemStack)(chanceOutput = recipe.getOutput(fallbackInput)).getMainOutput(), (ItemStack)output)) {
            if (extra.func_190926_b()) {
                return true;
            }
            ItemStack secondaryOutput = chanceOutput.getMaxSecondaryOutput();
            return secondaryOutput.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)secondaryOutput, (ItemStack)extra);
        }
        return false;
    }
}

