/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.CombinerCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.common.base.ITileComponent;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.tile.factory.TileEntityItemToItemFactory;
import mekanism.common.upgrade.CombinerUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityCombiningFactory
extends TileEntityItemToItemFactory<CombinerRecipe> {
    private final IInputHandler<@NonNull ItemStack> extraInputHandler;
    private InputInventorySlot extraSlot;

    public TileEntityCombiningFactory(IBlockProvider blockProvider) {
        super(blockProvider);
        this.extraInputHandler = InputHelper.getInputHandler(this.extraSlot);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder) {
        super.addSlots(builder);
        this.extraSlot = InputInventorySlot.at(stack -> this.containsRecipe(recipe -> recipe.getExtraInput().testType(stack)), this, 7, 57);
        builder.addSlot(this.extraSlot);
        this.extraSlot.setSlotType(ContainerSlotType.EXTRA);
    }

    @Override
    @Nullable
    protected InputInventorySlot getExtraSlot() {
        return this.extraSlot;
    }

    @Override
    public boolean isValidInputItem(@Nonnull ItemStack stack) {
        return this.containsRecipe(recipe -> recipe.getMainInput().testType(stack));
    }

    @Override
    public boolean inputProducesOutput(int process, @Nonnull ItemStack fallbackInput, @Nonnull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot, boolean updateCache) {
        ItemStack output;
        CombinerRecipe cachedRecipe;
        if (outputSlot.isEmpty()) {
            return true;
        }
        CachedRecipe cached = this.getCachedRecipe(process);
        if (cached != null && (cachedRecipe = (CombinerRecipe)cached.getRecipe()).getMainInput().testType(fallbackInput) && (this.extraSlot.isEmpty() || cachedRecipe.getExtraInput().testType(this.extraSlot.getStack()))) {
            return true;
        }
        ItemStack extra = this.extraSlot.getStack();
        CombinerRecipe foundRecipe = (CombinerRecipe)this.findFirstRecipe(arg_0 -> TileEntityCombiningFactory.lambda$inputProducesOutput$3(fallbackInput, extra, output = outputSlot.getStack(), arg_0));
        if (foundRecipe == null) {
            return false;
        }
        if (updateCache) {
            CachedRecipe<CombinerRecipe> newCachedRecipe = this.createNewCachedRecipe(foundRecipe, process);
            if (newCachedRecipe == null) {
                return false;
            }
            this.updateCachedRecipe(newCachedRecipe, process);
        }
        return true;
    }

    @Override
    @Nonnull
    public MekanismRecipeType<CombinerRecipe> getRecipeType() {
        return MekanismRecipeType.COMBINING;
    }

    @Override
    @Nullable
    public CombinerRecipe getRecipe(int cacheIndex) {
        ItemStack stack = (ItemStack)this.inputHandlers[cacheIndex].getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        ItemStack extra = this.extraInputHandler.getInput();
        if (extra.func_190926_b()) {
            return null;
        }
        return (CombinerRecipe)this.findFirstRecipe(recipe -> recipe.test(stack, extra));
    }

    @Override
    public CachedRecipe<CombinerRecipe> createNewCachedRecipe(@Nonnull CombinerRecipe recipe, int cacheIndex) {
        return new CombinerCachedRecipe(recipe, this.inputHandlers[cacheIndex], this.extraInputHandler, this.outputHandlers[cacheIndex]).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof CombinerUpgradeData) {
            int i;
            CombinerUpgradeData data = (CombinerUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.extraSlot.setStack(data.extraSlot.getStack());
            this.energySlot.setStack(data.energySlot.getStack());
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                ((IInventorySlot)this.inputSlots.get(i)).setStack(((IInventorySlot)data.inputSlots.get(i)).getStack());
            }
            for (i = 0; i < data.outputSlots.size(); ++i) {
                ((IInventorySlot)this.outputSlots.get(i)).setStack(((IInventorySlot)data.outputSlots.get(i)).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public CombinerUpgradeData getUpgradeData() {
        return new CombinerUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.energySlot, this.extraSlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    private static /* synthetic */ boolean lambda$inputProducesOutput$3(ItemStack fallbackInput, ItemStack extra, ItemStack output, CombinerRecipe recipe) {
        if (recipe.getMainInput().testType(fallbackInput) && (extra.func_190926_b() || recipe.getExtraInput().testType(extra))) {
            return ItemHandlerHelper.canItemStacksStack((ItemStack)recipe.getOutput(fallbackInput, extra), (ItemStack)output);
        }
        return false;
    }
}

