/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.RelativeSide;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.text.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.base.ITileComponent;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.inventory.container.ITrackableContainer;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.GasSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileComponentEjector
implements ITileComponent,
ITrackableContainer {
    private static final long GAS_OUTPUT = 256L;
    private static final int FLUID_OUTPUT = 256;
    private final TileEntityMekanism tile;
    private boolean strictInput;
    private EnumColor outputColor;
    private EnumColor[] inputColors = new EnumColor[]{null, null, null, null, null, null};
    private int tickDelay = 0;
    private Map<TransmissionType, ConfigInfo> configInfo = new EnumMap<TransmissionType, ConfigInfo>(TransmissionType.class);

    public TileComponentEjector(TileEntityMekanism tile) {
        this.tile = tile;
        tile.addComponent(this);
    }

    public TileComponentEjector setOutputData(TransmissionType type, @Nullable ConfigInfo info) {
        if (info != null) {
            this.configInfo.put(type, info);
        }
        return this;
    }

    @Override
    public void tick() {
        if (!this.tile.isRemote()) {
            if (this.tickDelay == 0) {
                this.outputItems();
            } else {
                --this.tickDelay;
            }
            this.eject(TransmissionType.GAS);
            this.eject(TransmissionType.FLUID);
        }
    }

    private void eject(TransmissionType type) {
        ISlotInfo slotInfo;
        ConfigInfo info = this.configInfo.get(type);
        if (info != null && info.isEjecting() && (slotInfo = info.getSlotInfo(DataType.OUTPUT)) != null) {
            Set<Direction> outputSides = info.getSidesForData(DataType.OUTPUT);
            if (type == TransmissionType.GAS && slotInfo instanceof GasSlotInfo) {
                ((GasSlotInfo)slotInfo).getTanks().forEach(tank -> GasUtils.emit(outputSides, tank, this.tile, 256L));
            } else if (type == TransmissionType.FLUID && slotInfo instanceof FluidSlotInfo) {
                ((FluidSlotInfo)slotInfo).getTanks().forEach(tank -> PipeUtils.emit(outputSides, tank, this.tile, 256));
            }
        }
    }

    private void outputItems() {
        TransitRequest ejectMap;
        ConfigInfo info = this.configInfo.get(TransmissionType.ITEM);
        if (info == null || !info.isEjecting()) {
            return;
        }
        ISlotInfo slotInfo = info.getSlotInfo(DataType.OUTPUT);
        if (!(slotInfo instanceof InventorySlotInfo)) {
            return;
        }
        Set<Direction> outputs = info.getSidesForData(DataType.OUTPUT);
        if (!outputs.isEmpty() && !(ejectMap = this.getEjectItemMap((InventorySlotInfo)slotInfo)).isEmpty()) {
            for (Direction side : outputs) {
                Optional<ILogisticalTransporter> capability;
                TransitRequest.TransitResponse response;
                TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.tile.func_145831_w(), this.tile.func_174877_v().func_177972_a(side));
                if (tile == null || (response = (capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, side.func_176734_d()))).isPresent() ? capability.get().insert(this.tile, ejectMap, this.outputColor, true, 0) : InventoryUtils.putStackInInventory(tile, ejectMap, side, false)).isEmpty()) continue;
                response.use(this.tile, side);
                if (!ejectMap.isEmpty()) continue;
                break;
            }
        }
        this.tickDelay = 10;
    }

    private TransitRequest getEjectItemMap(InventorySlotInfo slotInfo) {
        TransitRequest request = new TransitRequest();
        List<IInventorySlot> slots = slotInfo.getSlots();
        for (int index = 0; index < slots.size(); ++index) {
            IInventorySlot slot = slots.get(index);
            ItemStack simulatedExtraction = slot.extractItem(slot.getCount(), Action.SIMULATE, AutomationType.EXTERNAL);
            if (simulatedExtraction.func_190926_b()) continue;
            request.addItem(simulatedExtraction, index);
        }
        return request;
    }

    public boolean hasStrictInput() {
        return this.strictInput;
    }

    public void setStrictInput(boolean strict) {
        this.strictInput = strict;
        MekanismUtils.saveChunk(this.tile);
    }

    public EnumColor getOutputColor() {
        return this.outputColor;
    }

    public void setOutputColor(EnumColor color) {
        this.outputColor = color;
        MekanismUtils.saveChunk(this.tile);
    }

    public void setInputColor(RelativeSide side, EnumColor color) {
        this.inputColors[side.ordinal()] = color;
        MekanismUtils.saveChunk(this.tile);
    }

    public EnumColor getInputColor(RelativeSide side) {
        return this.inputColors[side.ordinal()];
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        if (nbtTags.func_150297_b("componentEjector", 10)) {
            CompoundNBT ejectorNBT = nbtTags.func_74775_l("componentEjector");
            this.strictInput = ejectorNBT.func_74767_n("strictInput");
            NBTUtils.setEnumIfPresent(ejectorNBT, "color", TransporterUtils::readColor, color -> {
                this.outputColor = color;
            });
            int i = 0;
            while (i < EnumUtils.DIRECTIONS.length) {
                int index = i++;
                NBTUtils.setEnumIfPresent(ejectorNBT, "color" + index, TransporterUtils::readColor, color -> {
                    this.inputColors[index] = color;
                });
            }
        }
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        CompoundNBT ejectorNBT = new CompoundNBT();
        ejectorNBT.func_74757_a("strictInput", this.strictInput);
        if (this.outputColor != null) {
            ejectorNBT.func_74768_a("color", TransporterUtils.getColorIndex(this.outputColor));
        }
        for (int i = 0; i < EnumUtils.DIRECTIONS.length; ++i) {
            ejectorNBT.func_74768_a("color" + i, TransporterUtils.getColorIndex(this.inputColors[i]));
        }
        nbtTags.func_218657_a("componentEjector", (INBT)ejectorNBT);
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
    }

    @Override
    public void addToUpdateTag(CompoundNBT updateTag) {
    }

    @Override
    public void readFromUpdateTag(CompoundNBT updateTag) {
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        container.track(SyncableBoolean.create(this::hasStrictInput, input -> {
            this.strictInput = input;
        }));
        container.track(SyncableInt.create(() -> TransporterUtils.getColorIndex(this.outputColor), index -> {
            this.outputColor = TransporterUtils.readColor(index);
        }));
        int i = 0;
        while (i < EnumUtils.DIRECTIONS.length) {
            int idx = i++;
            container.track(SyncableInt.create(() -> TransporterUtils.getColorIndex(this.inputColors[idx]), index -> {
                this.inputColors[idx] = TransporterUtils.readColor(index);
            }));
        }
    }
}

