/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Upgrade;
import mekanism.common.base.ITileComponent;
import mekanism.common.chunkloading.ChunkManager;
import mekanism.common.chunkloading.IChunkLoader;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.base.TileEntityUpdateable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileComponentChunkLoader<T extends TileEntityMekanism>
implements ITileComponent {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mekanism_TileComponentChunkLoader");
    private static final TicketType<TileComponentChunkLoader<?>> TICKET_TYPE = TicketType.func_219484_a((String)"mekanism:chunk_loader", Comparator.comparing(tccl -> tccl.tile.func_174877_v()));
    public static final int TICKET_DISTANCE = 2;
    private final T tile;
    private final Set<ChunkPos> chunkSet = new ObjectOpenHashSet();
    @Nullable
    private World prevWorld;
    @Nullable
    private BlockPos prevPos;
    private boolean hasRegistered;
    private boolean isFirstTick = true;

    public TileComponentChunkLoader(T tile) {
        this.tile = tile;
        ((TileEntityMekanism)tile).addComponent(this);
    }

    public boolean canOperate() {
        return MekanismConfig.general.allowChunkloading.get() && ((TileEntityMekanism)this.tile).supportsUpgrades() && ((TileEntityMekanism)this.tile).getComponent().isUpgradeInstalled(Upgrade.ANCHOR);
    }

    private void releaseChunkTickets(@Nonnull World world) {
        this.releaseChunkTickets(world, this.prevPos);
    }

    private void releaseChunkTickets(@Nonnull World world, @Nullable BlockPos pos) {
        LOGGER.debug("Attempting to remove chunk tickets. Pos: {} World: {}", (Object)pos, (Object)world.func_201675_m().func_186058_p().getRegistryName());
        ServerChunkProvider chunkProvider = (ServerChunkProvider)world.func_72863_F();
        Iterator<ChunkPos> chunkIt = this.chunkSet.iterator();
        ChunkManager manager = ChunkManager.getInstance((ServerWorld)world);
        while (chunkIt.hasNext()) {
            ChunkPos chunkPos = chunkIt.next();
            if (pos != null) {
                manager.deregisterChunk(chunkPos, pos);
            }
            chunkProvider.func_217222_b(TICKET_TYPE, chunkPos, 2, (Object)this);
            chunkIt.remove();
        }
        this.hasRegistered = false;
        this.prevWorld = null;
    }

    private void registerChunkTickets(@Nonnull World world) {
        ServerChunkProvider chunkProvider = (ServerChunkProvider)world.func_72863_F();
        ChunkManager manager = ChunkManager.getInstance((ServerWorld)world);
        this.prevPos = this.tile.func_174877_v();
        this.prevWorld = world;
        for (ChunkPos chunkPos : ((IChunkLoader)this.tile).getChunkSet()) {
            chunkProvider.func_217228_a(TICKET_TYPE, chunkPos, 2, (Object)this);
            manager.registerChunk(chunkPos, this.prevPos);
            this.chunkSet.add(chunkPos);
        }
        this.hasRegistered = true;
    }

    @Override
    public void tick() {
        World world = this.tile.func_145831_w();
        if (world != null && !world.field_72995_K && world.func_72863_F() instanceof ServerChunkProvider) {
            if (this.isFirstTick) {
                this.isFirstTick = false;
                if (!this.canOperate()) {
                    this.releaseChunkTickets(world, this.tile.func_174877_v());
                }
            }
            if (this.hasRegistered && this.prevWorld != null && (this.prevPos == null || this.prevWorld != world || this.prevPos != this.tile.func_174877_v())) {
                this.releaseChunkTickets(this.prevWorld);
            }
            if (this.hasRegistered && !this.canOperate()) {
                this.releaseChunkTickets(world);
            }
            if (this.canOperate() && !this.hasRegistered) {
                this.registerChunkTickets(world);
            }
        }
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        this.chunkSet.clear();
        ListNBT list = nbtTags.func_150295_c("chunkSet", 4);
        for (INBT nbt : list) {
            this.chunkSet.add(new ChunkPos(((LongNBT)nbt).func_150291_c()));
        }
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        ListNBT list = new ListNBT();
        for (ChunkPos pos : this.chunkSet) {
            list.add((Object)LongNBT.func_229698_a_((long)pos.func_201841_a()));
        }
        nbtTags.func_218657_a("chunkSet", (INBT)list);
    }

    @Override
    public void invalidate() {
        if (!((TileEntityUpdateable)((Object)this.tile)).isRemote() && this.prevWorld != null) {
            this.releaseChunkTickets(this.prevWorld);
        }
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
    }

    @Override
    public void addToUpdateTag(CompoundNBT updateTag) {
    }

    @Override
    public void readFromUpdateTag(CompoundNBT updateTag) {
    }

    public void refreshChunkTickets() {
        if (this.prevWorld != null) {
            this.releaseChunkTickets(this.prevWorld);
        }
        if (!((TileEntityUpdateable)((Object)this.tile)).isRemote()) {
            this.registerChunkTickets(Objects.requireNonNull(this.tile.func_145831_w()));
        }
    }
}

