/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.IConfigCardAccess;
import mekanism.api.RelativeSide;
import mekanism.api.sustained.ISustainedData;
import mekanism.common.HashList;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IFilter;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.list.SyncableFilterList;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityOredictionificator
extends TileEntityMekanism
implements IConfigCardAccess.ISpecialConfigData,
ISustainedData,
ITileFilterHolder<OredictionificatorFilter> {
    public static final Map<String, List<String>> possibleFilters = new Object2ObjectOpenHashMap();
    private HashList<OredictionificatorFilter> filters = new HashList();
    public boolean didProcess;
    private InputInventorySlot inputSlot;
    private OutputInventorySlot outputSlot;

    public TileEntityOredictionificator() {
        super(MekanismBlocks.OREDICTIONIFICATOR);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, this));
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        RelativeSide[] sides = new RelativeSide[]{RelativeSide.BOTTOM, RelativeSide.TOP, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK};
        this.inputSlot = InputInventorySlot.at(item -> !this.getResult((ItemStack)item).func_190926_b(), this, 26, 115);
        builder.addSlot(this.inputSlot, sides);
        this.outputSlot = OutputInventorySlot.at(this, 134, 115);
        builder.addSlot(this.outputSlot, sides);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        ItemStack result;
        ItemStack inputStack;
        super.onUpdateServer();
        this.didProcess = false;
        if (MekanismUtils.canFunction(this) && !this.inputSlot.isEmpty() && this.getValidName(inputStack = this.inputSlot.getStack()) != null && !(result = this.getResult(inputStack)).func_190926_b()) {
            ItemStack outputStack = this.outputSlot.getStack();
            if (outputStack.func_190926_b()) {
                this.inputSlot.shrinkStack(1, Action.EXECUTE);
                this.outputSlot.setStack(result);
                this.didProcess = true;
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)outputStack, (ItemStack)result) && outputStack.func_190916_E() < this.outputSlot.getLimit(outputStack)) {
                this.inputSlot.shrinkStack(1, Action.EXECUTE);
                this.outputSlot.growStack(1, Action.EXECUTE);
                this.didProcess = true;
            }
            this.markDirty(false);
        }
    }

    @Nullable
    public ResourceLocation getValidName(ItemStack stack) {
        Set tags = stack.func_77973_b().getTags();
        for (ResourceLocation resource : tags) {
            List filters = possibleFilters.getOrDefault(resource.func_110624_b(), Collections.emptyList());
            String path = resource.func_110623_a();
            for (String pre : filters) {
                if (!path.startsWith(pre)) continue;
                return resource;
            }
        }
        return null;
    }

    public ItemStack getResult(ItemStack stack) {
        ResourceLocation resource = this.getValidName(stack);
        if (resource == null) {
            return ItemStack.field_190927_a;
        }
        for (OredictionificatorFilter filter : this.filters) {
            if (!filter.filterMatches(resource)) continue;
            return filter.getResult();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        this.getConfigurationData(nbtTags);
        return nbtTags;
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        this.setConfigurationData(nbtTags);
    }

    @Override
    public CompoundNBT getConfigurationData(CompoundNBT nbtTags) {
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (OredictionificatorFilter filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            nbtTags.func_218657_a("filters", (INBT)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void setConfigurationData(CompoundNBT nbtTags) {
        if (nbtTags.func_150297_b("filters", 9)) {
            ListNBT tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof OredictionificatorFilter)) continue;
                this.filters.add((OredictionificatorFilter)filter);
            }
        }
    }

    @Override
    public String getDataType() {
        return this.getBlockType().func_149739_a();
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (OredictionificatorFilter filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "filters", 9)) {
            ListNBT tagList = ItemDataUtils.getList(itemStack, "filters");
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof OredictionificatorFilter)) continue;
                this.filters.add((OredictionificatorFilter)filter);
            }
        }
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("filters", "filters");
        return remap;
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public HashList<OredictionificatorFilter> getFilters() {
        return this.filters;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(() -> this.didProcess, value -> {
            this.didProcess = value;
        }));
        container.track(SyncableFilterList.create(this::getFilters, value -> {
            this.filters = value instanceof HashList ? (HashList)value : new HashList(value);
        }));
    }

    static {
        possibleFilters.put("forge", Arrays.asList("ingots/", "ores/", "dusts/", "nuggets/", "storage_blocks/"));
    }

    public static class OredictionificatorFilter
    extends BaseFilter<OredictionificatorFilter> {
        private ResourceLocation filterLocation;
        private Tag<Item> filterTag;
        @Nonnull
        private Item selectedOutput = Items.field_190931_a;

        public String getFilterText() {
            return this.filterLocation.toString();
        }

        public void setFilter(ResourceLocation location) {
            this.setFilterLocation(location);
            List<Item> matchingItems = this.getMatchingItems();
            this.selectedOutput = matchingItems.isEmpty() ? Items.field_190931_a : matchingItems.get(0);
        }

        private void setFilterLocation(ResourceLocation location) {
            this.filterLocation = location;
            this.filterTag = new ItemTags.Wrapper(this.filterLocation);
        }

        public boolean filterMatches(ResourceLocation location) {
            return this.filterLocation.equals((Object)location);
        }

        @Override
        public CompoundNBT write(CompoundNBT nbtTags) {
            super.write(nbtTags);
            nbtTags.func_74778_a("filter", this.getFilterText());
            if (this.selectedOutput != Items.field_190931_a) {
                nbtTags.func_74778_a("selected", this.selectedOutput.getRegistryName().toString());
            }
            return nbtTags;
        }

        @Override
        public void read(CompoundNBT nbtTags) {
            this.setFilterLocation(new ResourceLocation(nbtTags.func_74779_i("filter")));
            NBTUtils.setResourceLocationIfPresent(nbtTags, "selected", this::setSelectedOrAir);
        }

        @Override
        public void write(PacketBuffer buffer) {
            super.write(buffer);
            buffer.func_192572_a(this.filterLocation);
            buffer.func_192572_a(this.selectedOutput.getRegistryName());
        }

        @Override
        public void read(PacketBuffer dataStream) {
            this.setFilterLocation(dataStream.func_192575_l());
            this.setSelectedOrAir(dataStream.func_192575_l());
        }

        private void setSelectedOrAir(@Nonnull ResourceLocation resourceLocation) {
            Item output = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            this.selectedOutput = output == null ? Items.field_190931_a : output;
        }

        public List<Item> getMatchingItems() {
            if (this.hasFilter()) {
                return new ArrayList<Item>(this.filterTag.func_199885_a());
            }
            return Collections.emptyList();
        }

        public int getIndex() {
            List<Item> matchingItems = this.getMatchingItems();
            if (this.selectedOutput == Items.field_190931_a) {
                return 0;
            }
            int index = matchingItems.indexOf(this.selectedOutput);
            if (index == -1) {
                return 0;
            }
            return index;
        }

        public void next() {
            List<Item> matchingItems = this.getMatchingItems();
            int size = matchingItems.size();
            if (size > 1) {
                if (this.selectedOutput == Items.field_190931_a) {
                    this.selectedOutput = matchingItems.get(1);
                } else {
                    int index = matchingItems.indexOf(this.selectedOutput);
                    index = index < size - 1 ? ++index : 0;
                    this.selectedOutput = matchingItems.get(index);
                }
            }
        }

        public void previous() {
            List<Item> matchingItems = this.getMatchingItems();
            int size = matchingItems.size();
            if (size > 0) {
                if (this.selectedOutput == Items.field_190931_a) {
                    this.selectedOutput = matchingItems.get(size - 1);
                } else {
                    int index = matchingItems.indexOf(this.selectedOutput);
                    index = index == -1 ? 0 : (index > 0 ? --index : size - 1);
                    this.selectedOutput = matchingItems.get(index);
                }
            }
        }

        public ItemStack getResult() {
            if (!this.hasFilter()) {
                return ItemStack.field_190927_a;
            }
            List<Item> matchingItems = this.getMatchingItems();
            if (matchingItems.isEmpty()) {
                return ItemStack.field_190927_a;
            }
            if (this.selectedOutput == Items.field_190931_a || !matchingItems.contains(this.selectedOutput)) {
                this.selectedOutput = matchingItems.get(0);
            }
            return new ItemStack((IItemProvider)this.selectedOutput);
        }

        @Override
        public OredictionificatorFilter clone() {
            OredictionificatorFilter newFilter = new OredictionificatorFilter();
            newFilter.filterLocation = this.filterLocation;
            newFilter.filterTag = this.filterTag;
            newFilter.selectedOutput = this.selectedOutput;
            return newFilter;
        }

        @Override
        public FilterType getFilterType() {
            return FilterType.OREDICTIONIFICATOR;
        }

        @Override
        public int hashCode() {
            int code = 1;
            code = 31 * code + this.filterLocation.hashCode();
            return code;
        }

        public boolean hasFilter() {
            return this.filterLocation != null;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof OredictionificatorFilter && this.filterLocation.equals((Object)((OredictionificatorFilter)obj).filterLocation);
        }
    }
}

