/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.config.value.CachedFloatingLongValue;
import net.minecraft.util.IStringSerializable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public enum EnergyCubeTier implements ITier,
IStringSerializable
{
    BASIC(BaseTier.BASIC, FloatingLong.createConst(2000000L), FloatingLong.createConst(800L)),
    ADVANCED(BaseTier.ADVANCED, FloatingLong.createConst(8000000L), FloatingLong.createConst(3200L)),
    ELITE(BaseTier.ELITE, FloatingLong.createConst(32000000L), FloatingLong.createConst(12800L)),
    ULTIMATE(BaseTier.ULTIMATE, FloatingLong.createConst(128000000L), FloatingLong.createConst(51200L)),
    CREATIVE(BaseTier.CREATIVE, FloatingLong.MAX_VALUE, FloatingLong.MAX_VALUE);

    private final FloatingLong baseMaxEnergy;
    private final FloatingLong baseOutput;
    private final BaseTier baseTier;
    private CachedFloatingLongValue storageReference;
    private CachedFloatingLongValue outputReference;

    private EnergyCubeTier(BaseTier tier, FloatingLong max, FloatingLong out) {
        this.baseMaxEnergy = max;
        this.baseOutput = out;
        this.baseTier = tier;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public FloatingLong getMaxEnergy() {
        return this.storageReference == null ? this.getBaseMaxEnergy() : (FloatingLong)this.storageReference.get();
    }

    public FloatingLong getOutput() {
        return this.outputReference == null ? this.getBaseOutput() : (FloatingLong)this.outputReference.get();
    }

    public FloatingLong getBaseMaxEnergy() {
        return this.baseMaxEnergy;
    }

    public FloatingLong getBaseOutput() {
        return this.baseOutput;
    }

    public void setConfigReference(CachedFloatingLongValue storageReference, CachedFloatingLongValue outputReference) {
        this.storageReference = storageReference;
        this.outputReference = outputReference;
    }
}

