/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import mekanism.common.Mekanism;
import mekanism.common.base.IChemicalConstant;
import mekanism.common.registration.impl.FluidRegistryObject;
import mekanism.common.registration.impl.ItemDeferredRegister;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidDeferredRegister {
    private static final ResourceLocation OVERLAY = new ResourceLocation("minecraft", "block/water_overlay");
    private final List<FluidRegistryObject<?, ?, ?, ?>> allFluids = new ArrayList();
    private final String modid;
    private final DeferredRegister<Fluid> fluidRegister;
    private final DeferredRegister<Block> blockRegister;
    private final DeferredRegister<Item> itemRegister;

    public FluidDeferredRegister(String modid) {
        this.modid = modid;
        this.blockRegister = new DeferredRegister(ForgeRegistries.BLOCKS, modid);
        this.fluidRegister = new DeferredRegister(ForgeRegistries.FLUIDS, modid);
        this.itemRegister = new DeferredRegister(ForgeRegistries.ITEMS, modid);
    }

    public FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem> registerLiquidChemical(IChemicalConstant constants) {
        int density = Math.round(constants.getDensity());
        return this.register(constants.getName(), fluidAttributes -> fluidAttributes.color(constants.getColor()).temperature(Math.round(constants.getTemperature())).density(density).viscosity(density).luminosity(constants.getLuminosity()).gaseous());
    }

    public FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem> register(String name, UnaryOperator<FluidAttributes.Builder> fluidAttributes) {
        return this.register(name, (FluidAttributes.Builder)fluidAttributes.apply(FluidAttributes.builder((ResourceLocation)Mekanism.rl("liquid/liquid"), (ResourceLocation)Mekanism.rl("liquid/liquid_flow"))));
    }

    public FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem> register(String name, FluidAttributes.Builder builder) {
        String flowingName = "flowing_" + name;
        String bucketName = name + "_bucket";
        builder.overlay(OVERLAY);
        FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem> fluidRegistryObject = new FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>(this.modid, name);
        ForgeFlowingFluid.Properties properties = new ForgeFlowingFluid.Properties(fluidRegistryObject::getStillFluid, fluidRegistryObject::getFlowingFluid, builder).bucket(fluidRegistryObject::getBucket).block(fluidRegistryObject::getBlock);
        fluidRegistryObject.updateStill(this.fluidRegister.register(name, () -> new ForgeFlowingFluid.Source(properties)));
        fluidRegistryObject.updateFlowing(this.fluidRegister.register(flowingName, () -> new ForgeFlowingFluid.Flowing(properties)));
        fluidRegistryObject.updateBucket(this.itemRegister.register(bucketName, () -> new BucketItem(fluidRegistryObject::getStillFluid, ItemDeferredRegister.getMekBaseProperties().func_200917_a(1).func_200919_a(Items.field_151133_ar))));
        fluidRegistryObject.updateBlock(this.blockRegister.register(name, () -> new FlowingFluidBlock(fluidRegistryObject::getStillFluid, Block.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e())));
        this.allFluids.add(fluidRegistryObject);
        return fluidRegistryObject;
    }

    public void register(IEventBus bus) {
        this.blockRegister.register(bus);
        this.fluidRegister.register(bus);
        this.itemRegister.register(bus);
    }

    public List<FluidRegistryObject<?, ?, ?, ?>> getAllFluids() {
        return this.allFluids;
    }
}

