/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.DataHandlerUtils;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.block.IHasTileEntity;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.providers.IGasProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class GasRecipeData
implements RecipeUpgradeData<GasRecipeData> {
    private final List<IGasTank> gasTanks;

    GasRecipeData(ListNBT tanks) {
        int count = DataHandlerUtils.getMaxId(tanks, "Tank");
        this.gasTanks = new ArrayList<IGasTank>(count);
        for (int i = 0; i < count; ++i) {
            this.gasTanks.add(BasicGasTank.create(Long.MAX_VALUE, null));
        }
        DataHandlerUtils.readTanks(this.gasTanks, tanks);
    }

    GasRecipeData(List<IGasTank> gasTanks) {
        this.gasTanks = gasTanks;
    }

    @Override
    @Nullable
    public GasRecipeData merge(GasRecipeData other) {
        ArrayList<IGasTank> allTanks = new ArrayList<IGasTank>(this.gasTanks.size() + other.gasTanks.size());
        allTanks.addAll(this.gasTanks);
        allTanks.addAll(other.gasTanks);
        return new GasRecipeData(allTanks);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.gasTanks.isEmpty()) {
            return true;
        }
        Item item = stack.func_77973_b();
        Optional capability = MekanismUtils.toOptional(stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY));
        final ArrayList<BasicGasTank> gasTanks = new ArrayList<BasicGasTank>();
        if (capability.isPresent()) {
            IGasHandler gasHandler = (IGasHandler)capability.get();
            int i = 0;
            while (i < gasHandler.getGasTankCount()) {
                int tank = i++;
                gasTanks.add(BasicGasTank.create(gasHandler.getGasTankCapacity(tank), gas -> gasHandler.isGasValid(tank, new GasStack((IGasProvider)gas, 1L)), null));
            }
        } else if (item instanceof BlockItem) {
            TileEntity tileEntity;
            TileEntityMekanism tile = null;
            Block block = ((BlockItem)item).func_179223_d();
            if (block instanceof IHasTileEntity && (tileEntity = ((IHasTileEntity)block).getTileType().func_200968_a()) instanceof TileEntityMekanism) {
                tile = (TileEntityMekanism)tileEntity;
            }
            if (tile == null || !tile.handles(SubstanceType.GAS)) {
                return false;
            }
            TileEntityMekanism mekTile = tile;
            int i = 0;
            while (i < tile.getGasTankCount()) {
                int tank = i++;
                gasTanks.add(BasicGasTank.create(tile.getGasTankCapacity(tank), gas -> mekTile.isGasValid(tank, new GasStack((IGasProvider)gas, 1L)), null));
            }
        } else {
            return false;
        }
        if (gasTanks.isEmpty()) {
            return true;
        }
        IMekanismGasHandler outputHandler = new IMekanismGasHandler(){

            @Override
            @Nonnull
            public List<IGasTank> getGasTanks(@Nullable Direction side) {
                return gasTanks;
            }

            @Override
            public void onContentsChanged() {
            }
        };
        boolean hasData = false;
        for (IGasTank gasTank : this.gasTanks) {
            if (gasTank.isEmpty()) continue;
            if (!outputHandler.insertGas((GasStack)gasTank.getStack(), Action.EXECUTE).isEmpty()) {
                return false;
            }
            hasData = true;
        }
        if (hasData) {
            ItemDataUtils.setList(stack, "GasTanks", DataHandlerUtils.writeTanks(gasTanks));
        }
        return true;
    }
}

