/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FluidToFluidRecipeSerializer<T extends FluidToFluidRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;

    public FluidToFluidRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @Nonnull
    public T read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? JSONUtils.func_151214_t((JsonObject)json, (String)"input") : JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        FluidStackIngredient inputIngredient = FluidStackIngredient.deserialize((JsonElement)input);
        FluidStack output = SerializerHelper.getFluidStack(json, "output");
        if (output.isEmpty()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, inputIngredient, output);
    }

    public T read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            FluidStackIngredient inputIngredient = FluidStackIngredient.read(buffer);
            FluidStack output = FluidStack.readFromPacket((PacketBuffer)buffer);
            return this.factory.create(recipeId, inputIngredient, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading fluid to fluid recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull T recipe) {
        try {
            ((FluidToFluidRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing fluid to fluid recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    public static interface IFactory<T extends FluidToFluidRecipe> {
        public T create(ResourceLocation var1, FluidStackIngredient var2, FluidStack var3);
    }
}

