/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.bin;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.inventory.AutomationType;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.recipe.bin.BinRecipe;
import mekanism.common.registries.MekanismRecipeSerializers;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BinInsertRecipe
extends BinRecipe {
    public BinInsertRecipe(ResourceLocation id) {
        super(id);
    }

    @Override
    public boolean matches(CraftingInventory inv, World world) {
        ItemStack binStack = ItemStack.field_190927_a;
        ItemStack foundType = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (stackInSlot.func_77973_b() instanceof ItemBlockBin) {
                if (!binStack.func_190926_b()) {
                    return false;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.func_190926_b()) {
                foundType = stackInSlot;
                continue;
            }
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)foundType, (ItemStack)stackInSlot)) continue;
            return false;
        }
        if (binStack.func_190926_b() || foundType.func_190926_b()) {
            return false;
        }
        BinInventorySlot slot = BinInsertRecipe.convertToSlot(binStack);
        ItemStack remaining = slot.insertItem(foundType, Action.SIMULATE, AutomationType.MANUAL);
        return !ItemStack.func_77989_b((ItemStack)remaining, (ItemStack)foundType);
    }

    @Override
    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack binStack = ItemStack.field_190927_a;
        ItemStack foundType = ItemStack.field_190927_a;
        ArrayList<ItemStack> foundItems = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (stackInSlot.func_77973_b() instanceof ItemBlockBin) {
                if (!binStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.func_190926_b()) {
                foundType = stackInSlot;
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)foundType, (ItemStack)stackInSlot)) {
                return ItemStack.field_190927_a;
            }
            foundItems.add(StackUtils.size(stackInSlot, 1));
        }
        if (binStack.func_190926_b() || foundType.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        binStack = binStack.func_77946_l();
        BinInventorySlot slot = BinInsertRecipe.convertToSlot(binStack);
        boolean hasInserted = false;
        for (ItemStack stack : foundItems) {
            if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)slot.insertItem(stack, Action.EXECUTE, AutomationType.MANUAL))) {
                if (hasInserted) break;
                return ItemStack.field_190927_a;
            }
            hasInserted = true;
        }
        ItemDataUtils.setBoolean(binStack, "fromRecipe", true);
        return binStack;
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStack binStack = ItemStack.field_190927_a;
        ItemStack foundType = ItemStack.field_190927_a;
        IntArrayList foundSlots = new IntArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (stackInSlot.func_77973_b() instanceof ItemBlockBin) {
                if (!binStack.func_190926_b()) {
                    return remainingItems;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.func_190926_b()) {
                foundType = stackInSlot;
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)foundType, (ItemStack)stackInSlot)) {
                return remainingItems;
            }
            foundSlots.add(i);
        }
        if (binStack.func_190926_b() || foundType.func_190926_b()) {
            return remainingItems;
        }
        binStack = binStack.func_77946_l();
        BinInventorySlot slot = BinInsertRecipe.convertToSlot(binStack);
        for (int i = 0; i < foundSlots.size(); ++i) {
            int index = foundSlots.getInt(i);
            ItemStack stack = StackUtils.size(inv.func_70301_a(index), 1);
            ItemStack remaining = slot.insertItem(stack, Action.EXECUTE, AutomationType.MANUAL);
            remainingItems.set(index, (Object)remaining);
        }
        return remainingItems;
    }

    @Override
    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return MekanismRecipeSerializers.BIN_INSERT.getRecipeSerializer();
    }

    @SubscribeEvent
    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        BinInventorySlot slot;
        ItemStack storedStack;
        ItemStack result = event.getCrafting();
        if (!result.func_190926_b() && result.func_77973_b() instanceof ItemBlockBin && ItemDataUtils.getBoolean(result, "fromRecipe") && !(storedStack = (slot = BinInsertRecipe.convertToSlot(result)).getStack()).func_190926_b()) {
            IInventory craftingMatrix = event.getInventory();
            for (int i = 0; i < craftingMatrix.func_70302_i_(); ++i) {
                ItemStack stack = craftingMatrix.func_70301_a(i);
                if (!(stack = StackUtils.size(stack, stack.func_190916_E() - 1)).func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)storedStack, (ItemStack)stack)) {
                    ItemStack remaining = slot.insertItem(stack, Action.EXECUTE, AutomationType.MANUAL);
                    craftingMatrix.func_70299_a(i, remaining);
                    continue;
                }
                craftingMatrix.func_70299_a(i, ItemStack.field_190927_a);
            }
            ItemDataUtils.removeData(storedStack, "fromRecipe");
        }
    }
}

