/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.container.property;

import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.container.PacketUpdateContainer;
import mekanism.common.network.container.property.BooleanPropertyData;
import mekanism.common.network.container.property.BytePropertyData;
import mekanism.common.network.container.property.DoublePropertyData;
import mekanism.common.network.container.property.FloatPropertyData;
import mekanism.common.network.container.property.FloatingLongPropertyData;
import mekanism.common.network.container.property.FluidStackPropertyData;
import mekanism.common.network.container.property.FrequencyPropertyData;
import mekanism.common.network.container.property.GasStackPropertyData;
import mekanism.common.network.container.property.InfusionStackPropertyData;
import mekanism.common.network.container.property.IntPropertyData;
import mekanism.common.network.container.property.ItemStackPropertyData;
import mekanism.common.network.container.property.LongPropertyData;
import mekanism.common.network.container.property.PropertyType;
import mekanism.common.network.container.property.ShortPropertyData;
import mekanism.common.network.container.property.list.ListPropertyData;
import net.minecraft.network.PacketBuffer;

public abstract class PropertyData {
    private final PropertyType type;
    private final short property;

    protected PropertyData(PropertyType type, short property) {
        this.type = type;
        this.property = property;
    }

    public PropertyType getType() {
        return this.type;
    }

    public short getProperty() {
        return this.property;
    }

    public abstract PacketUpdateContainer<?> getSinglePacket(short var1);

    public abstract void handleWindowProperty(MekanismContainer var1);

    public void writeToPacket(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.type);
        buffer.writeShort((int)this.property);
    }

    public static PropertyData fromBuffer(PacketBuffer buffer) {
        PropertyType type = (PropertyType)buffer.func_179257_a(PropertyType.class);
        short property = buffer.readShort();
        switch (type) {
            case BOOLEAN: {
                return new BooleanPropertyData(property, buffer.readBoolean());
            }
            case BYTE: {
                return new BytePropertyData(property, buffer.readByte());
            }
            case DOUBLE: {
                return new DoublePropertyData(property, buffer.readDouble());
            }
            case FLOAT: {
                return new FloatPropertyData(property, buffer.readFloat());
            }
            case INT: {
                return new IntPropertyData(property, buffer.func_150792_a());
            }
            case LONG: {
                return new LongPropertyData(property, buffer.func_179260_f());
            }
            case SHORT: {
                return new ShortPropertyData(property, buffer.readShort());
            }
            case ITEM_STACK: {
                return new ItemStackPropertyData(property, buffer.func_150791_c());
            }
            case FLUID_STACK: {
                return new FluidStackPropertyData(property, buffer.readFluidStack());
            }
            case GAS_STACK: {
                return new GasStackPropertyData(property, ChemicalUtils.readGasStack(buffer));
            }
            case INFUSION_STACK: {
                return new InfusionStackPropertyData(property, ChemicalUtils.readInfusionStack(buffer));
            }
            case FREQUENCY: {
                return FrequencyPropertyData.readFrequency(property, buffer);
            }
            case FLOATING_LONG: {
                return new FloatingLongPropertyData(property, FloatingLong.readFromBuffer(buffer));
            }
            case LIST: {
                return ListPropertyData.readList(property, buffer);
            }
        }
        Mekanism.logger.error("Unrecognized property type received: {}", (Object)type);
        return null;
    }
}

