/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.container.property;

import javax.annotation.Nullable;
import mekanism.common.frequency.Frequency;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.container.PacketUpdateContainerFrequency;
import mekanism.common.network.container.property.PropertyData;
import mekanism.common.network.container.property.PropertyType;
import net.minecraft.network.PacketBuffer;

public class FrequencyPropertyData<FREQUENCY extends Frequency>
extends PropertyData {
    @Nullable
    private final FREQUENCY value;

    public FrequencyPropertyData(short property, @Nullable FREQUENCY value) {
        super(PropertyType.FREQUENCY, property);
        this.value = value;
    }

    public static <FREQUENCY extends Frequency> FrequencyPropertyData<FREQUENCY> readFrequency(short property, PacketBuffer buffer) {
        return new FrequencyPropertyData<Frequency>(property, buffer.readBoolean() ? Frequency.readFromPacket(buffer) : null);
    }

    public PacketUpdateContainerFrequency<FREQUENCY> getSinglePacket(short windowId) {
        return new PacketUpdateContainerFrequency<FREQUENCY>(windowId, this.getProperty(), this.value);
    }

    @Override
    public void handleWindowProperty(MekanismContainer container) {
        container.handleWindowProperty(this.getProperty(), this.value);
    }

    @Override
    public void writeToPacket(PacketBuffer buffer) {
        super.writeToPacket(buffer);
        if (this.value == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            ((Frequency)this.value).write(buffer);
        }
    }
}

