/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import mekanism.common.Mekanism;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.network.PacketPlayerData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGearStateUpdate {
    private final GearType gearType;
    private final boolean state;
    private final UUID uuid;

    public PacketGearStateUpdate(GearType gearType, UUID uuid, boolean state) {
        this.gearType = gearType;
        this.uuid = uuid;
        this.state = state;
    }

    public static void handle(PacketGearStateUpdate message, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = BasePacketHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        context.get().enqueueWork(() -> {
            if (message.gearType == GearType.FLAMETHROWER) {
                Mekanism.playerState.setFlamethrowerState(message.uuid, message.state, false);
            } else if (message.gearType == GearType.JETPACK) {
                Mekanism.playerState.setJetpackState(message.uuid, message.state, false);
            } else if (message.gearType == GearType.GAS_MASK) {
                Mekanism.playerState.setGasmaskState(message.uuid, message.state, false);
            }
            if (!player.field_70170_p.field_72995_K) {
                Mekanism.packetHandler.sendToAllTracking(new PacketPlayerData(message.uuid), (Entity)player);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(PacketGearStateUpdate pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.gearType);
        buf.func_179252_a(pkt.uuid);
        buf.writeBoolean(pkt.state);
    }

    public static PacketGearStateUpdate decode(PacketBuffer buf) {
        return new PacketGearStateUpdate((GearType)buf.func_179257_a(GearType.class), buf.func_179253_g(), buf.readBoolean());
    }

    public static enum GearType {
        FLAMETHROWER,
        JETPACK,
        GAS_MASK;

    }
}

