/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.HashList;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketEditFilter {
    private final IFilter<?> filter;
    private final IFilter<?> edited;
    private final boolean delete;
    private final BlockPos pos;

    public PacketEditFilter(BlockPos pos, boolean deletion, IFilter<?> filter, IFilter<?> edited) {
        this.pos = pos;
        this.delete = deletion;
        this.filter = filter;
        this.edited = edited;
    }

    public static void handle(PacketEditFilter message, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = BasePacketHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        context.get().enqueueWork(() -> {
            HashList<TileEntityOredictionificator.OredictionificatorFilter> filters;
            int index;
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)player.field_70170_p, message.pos);
            if (message.filter instanceof TransporterFilter && tile instanceof TileEntityLogisticalSorter) {
                HashList<TransporterFilter<?>> filters2 = ((TileEntityLogisticalSorter)tile).getFilters();
                int index2 = filters2.indexOf(message.filter);
                if (index2 != -1) {
                    filters2.remove(index2);
                    if (!message.delete) {
                        filters2.add(index2, (TransporterFilter)message.edited);
                    }
                }
            } else if (message.filter instanceof MinerFilter && tile instanceof TileEntityDigitalMiner) {
                HashList<MinerFilter<?>> filters3 = ((TileEntityDigitalMiner)tile).getFilters();
                int index3 = filters3.indexOf(message.filter);
                if (index3 != -1) {
                    filters3.remove(index3);
                    if (!message.delete) {
                        filters3.add(index3, (MinerFilter)message.edited);
                    }
                }
            } else if (message.filter instanceof TileEntityOredictionificator.OredictionificatorFilter && tile instanceof TileEntityOredictionificator && (index = (filters = ((TileEntityOredictionificator)tile).getFilters()).indexOf(message.filter)) != -1) {
                filters.remove(index);
                if (!message.delete) {
                    filters.add(index, (TileEntityOredictionificator.OredictionificatorFilter)message.edited);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(PacketEditFilter pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.writeBoolean(pkt.delete);
        pkt.filter.write(buf);
        if (!pkt.delete) {
            pkt.edited.write(buf);
        }
    }

    public static PacketEditFilter decode(PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        IFilter<?> edited = null;
        boolean delete = buf.readBoolean();
        IFilter<?> filter = BaseFilter.readFromPacket(buf);
        if (!delete) {
            edited = BaseFilter.readFromPacket(buf);
        }
        return new PacketEditFilter(pos, delete, filter, edited);
    }
}

