/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.RelativeSide;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketConfigurationUpdate {
    private final ConfigurationPacket packetType;
    private final BlockPos pos;
    private TransmissionType transmission;
    private RelativeSide inputSide;
    private int clickType;

    public PacketConfigurationUpdate(BlockPos pos, TransmissionType trans) {
        this.packetType = ConfigurationPacket.EJECT;
        this.pos = pos;
        this.transmission = trans;
    }

    public PacketConfigurationUpdate(BlockPos pos, int click) {
        this.packetType = ConfigurationPacket.EJECT_COLOR;
        this.pos = pos;
        this.clickType = click;
    }

    public PacketConfigurationUpdate(BlockPos pos) {
        this.packetType = ConfigurationPacket.STRICT_INPUT;
        this.pos = pos;
    }

    public PacketConfigurationUpdate(@Nonnull ConfigurationPacket type, BlockPos pos, int click, RelativeSide inputSide, TransmissionType trans) {
        this.packetType = type;
        this.pos = pos;
        if (this.packetType == ConfigurationPacket.EJECT) {
            this.transmission = trans;
        } else if (this.packetType == ConfigurationPacket.EJECT_COLOR) {
            this.clickType = click;
        } else if (this.packetType == ConfigurationPacket.SIDE_DATA) {
            this.clickType = click;
            this.inputSide = inputSide;
            this.transmission = trans;
        } else if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
            this.clickType = click;
            this.inputSide = inputSide;
        }
    }

    public static void handle(PacketConfigurationUpdate message, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = BasePacketHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        context.get().enqueueWork(() -> {
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)player.field_70170_p, message.pos);
            if (tile instanceof ISideConfiguration) {
                ISideConfiguration config = (ISideConfiguration)tile;
                if (message.packetType == ConfigurationPacket.EJECT) {
                    ConfigInfo info = config.getConfig().getConfig(message.transmission);
                    if (info != null) {
                        info.setEjecting(!info.isEjecting());
                    }
                } else if (message.packetType == ConfigurationPacket.SIDE_DATA) {
                    TileComponentConfig configComponent = config.getConfig();
                    ConfigInfo info = configComponent.getConfig(message.transmission);
                    if (info != null) {
                        boolean changed = true;
                        if (message.clickType == 0) {
                            info.incrementDataType(message.inputSide);
                        } else if (message.clickType == 1) {
                            info.decrementDataType(message.inputSide);
                        } else if (message.clickType == 2) {
                            if (info.getDataType(message.inputSide) == DataType.NONE) {
                                changed = false;
                            }
                            info.setDataType(message.inputSide, DataType.NONE);
                        }
                        if (changed) {
                            configComponent.sideChanged(message.transmission, message.inputSide);
                        }
                    }
                } else if (message.packetType == ConfigurationPacket.EJECT_COLOR) {
                    TileComponentEjector ejector = config.getEjector();
                    if (message.clickType == 0) {
                        ejector.setOutputColor(TransporterUtils.increment(ejector.getOutputColor()));
                    } else if (message.clickType == 1) {
                        ejector.setOutputColor(TransporterUtils.decrement(ejector.getOutputColor()));
                    } else if (message.clickType == 2) {
                        ejector.setOutputColor(null);
                    }
                } else if (message.packetType == ConfigurationPacket.INPUT_COLOR) {
                    TileComponentEjector ejector = config.getEjector();
                    if (message.clickType == 0) {
                        ejector.setInputColor(message.inputSide, TransporterUtils.increment(ejector.getInputColor(message.inputSide)));
                    } else if (message.clickType == 1) {
                        ejector.setInputColor(message.inputSide, TransporterUtils.decrement(ejector.getInputColor(message.inputSide)));
                    } else if (message.clickType == 2) {
                        ejector.setInputColor(message.inputSide, null);
                    }
                } else if (message.packetType == ConfigurationPacket.STRICT_INPUT) {
                    TileComponentEjector ejector;
                    ejector.setStrictInput(!(ejector = config.getEjector()).hasStrictInput());
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(PacketConfigurationUpdate pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.packetType);
        buf.func_179255_a(pkt.pos);
        if (pkt.packetType == ConfigurationPacket.EJECT) {
            buf.func_179249_a((Enum)pkt.transmission);
        } else if (pkt.packetType == ConfigurationPacket.SIDE_DATA) {
            buf.func_150787_b(pkt.clickType);
            buf.func_179249_a((Enum)pkt.inputSide);
            buf.func_179249_a((Enum)pkt.transmission);
        } else if (pkt.packetType == ConfigurationPacket.EJECT_COLOR) {
            buf.func_150787_b(pkt.clickType);
        } else if (pkt.packetType == ConfigurationPacket.INPUT_COLOR) {
            buf.func_150787_b(pkt.clickType);
            buf.func_179249_a((Enum)pkt.inputSide);
        }
    }

    public static PacketConfigurationUpdate decode(PacketBuffer buf) {
        ConfigurationPacket packetType = (ConfigurationPacket)buf.func_179257_a(ConfigurationPacket.class);
        BlockPos pos = buf.func_179259_c();
        int clickType = 0;
        RelativeSide inputSide = null;
        TransmissionType transmission = null;
        if (packetType == ConfigurationPacket.EJECT) {
            transmission = (TransmissionType)buf.func_179257_a(TransmissionType.class);
        } else if (packetType == ConfigurationPacket.SIDE_DATA) {
            clickType = buf.func_150792_a();
            inputSide = (RelativeSide)buf.func_179257_a(RelativeSide.class);
            transmission = (TransmissionType)buf.func_179257_a(TransmissionType.class);
        } else if (packetType == ConfigurationPacket.EJECT_COLOR) {
            clickType = buf.func_150792_a();
        } else if (packetType == ConfigurationPacket.INPUT_COLOR) {
            clickType = buf.func_150792_a();
            inputSide = (RelativeSide)buf.func_179257_a(RelativeSide.class);
        }
        return new PacketConfigurationUpdate(packetType, pos, clickType, inputSide, transmission);
    }

    public static enum ConfigurationPacket {
        EJECT,
        SIDE_DATA,
        EJECT_COLOR,
        INPUT_COLOR,
        STRICT_INPUT;

    }
}

