/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Upgrade;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.base.IUpgradeItem;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.BasicInventorySlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class UpgradeInventorySlot
extends BasicInventorySlot {
    private final Set<Upgrade> supportedTypes;

    public static UpgradeInventorySlot of(@Nullable IMekanismInventory inventory, Set<Upgrade> supportedTypes) {
        Objects.requireNonNull(supportedTypes, "Supported types cannot be null");
        return new UpgradeInventorySlot(inventory, supportedTypes);
    }

    private UpgradeInventorySlot(@Nullable IMekanismInventory inventory, Set<Upgrade> supportedTypes) {
        super(manualOnly, (ItemStack stack, AutomationType automationType) -> {
            Item item = stack.func_77973_b();
            if (item instanceof IUpgradeItem) {
                Upgrade upgradeType = ((IUpgradeItem)item).getUpgradeType((ItemStack)stack);
                return supportedTypes.contains(upgradeType);
            }
            return false;
        }, (ItemStack stack) -> stack.func_77973_b() instanceof IUpgradeItem, inventory, 154, 7);
        this.supportedTypes = supportedTypes;
        this.setSlotOverlay(SlotOverlay.UPGRADE);
    }

    public Set<Upgrade> getSupportedUpgrade() {
        return this.supportedTypes;
    }
}

