/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSGas;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

@RecipeTypeMapper
public class PressurizedReactionRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekPressurizedReaction";
    }

    public String getDescription() {
        return "Maps Mekanism pressurized reaction recipes.";
    }

    public boolean canHandle(IRecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.REACTION;
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, IRecipe<?> iRecipe) {
        if (!(iRecipe instanceof PressurizedReactionRecipe)) {
            return false;
        }
        boolean handled = false;
        PressurizedReactionRecipe recipe = (PressurizedReactionRecipe)iRecipe;
        List<@NonNull TYPE> itemRepresentations = recipe.getInputSolid().getRepresentations();
        List<@NonNull TYPE> fluidRepresentations = recipe.getInputFluid().getRepresentations();
        List<@NonNull TYPE> gasRepresentations = recipe.getInputGas().getRepresentations();
        for (ItemStack itemRepresentation : itemRepresentations) {
            NSSItem nssItem = NSSItem.createItem((ItemStack)itemRepresentation);
            for (FluidStack fluidRepresentation : fluidRepresentations) {
                NSSFluid nssFluid = NSSFluid.createFluid((FluidStack)fluidRepresentation);
                for (GasStack gasRepresentation : gasRepresentations) {
                    NSSGas nssGas = NSSGas.createGas(gasRepresentation);
                    Pair<@NonNull ItemStack, @NonNull GasStack> output = recipe.getOutput(itemRepresentation, fluidRepresentation, gasRepresentation);
                    ItemStack itemOutput = (ItemStack)output.getLeft();
                    GasStack gasOutput = (GasStack)output.getRight();
                    IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                    ingredientHelper.put((NormalizedSimpleStack)nssItem, itemRepresentation.func_190916_E());
                    ingredientHelper.put((NormalizedSimpleStack)nssFluid, fluidRepresentation.getAmount());
                    ingredientHelper.put((NormalizedSimpleStack)nssGas, gasRepresentation.getAmount());
                    if (itemOutput.func_190926_b()) {
                        if (gasOutput.isEmpty() || !ingredientHelper.addAsConversion(gasOutput)) continue;
                        handled = true;
                        continue;
                    }
                    if (gasOutput.isEmpty()) {
                        if (!ingredientHelper.addAsConversion(itemOutput)) continue;
                        handled = true;
                        continue;
                    }
                    NSSItem nssItemOutput = NSSItem.createItem((ItemStack)itemOutput);
                    NSSGas nssGasOutput = NSSGas.createGas(gasOutput);
                    ingredientHelper.put((NormalizedSimpleStack)nssGasOutput, -gasOutput.getAmount());
                    if (ingredientHelper.addAsConversion((NormalizedSimpleStack)nssItemOutput, itemOutput.func_190916_E())) {
                        handled = true;
                    }
                    ingredientHelper.resetHelper();
                    ingredientHelper.put((NormalizedSimpleStack)nssItem, itemRepresentation.func_190916_E());
                    ingredientHelper.put((NormalizedSimpleStack)nssFluid, fluidRepresentation.getAmount());
                    ingredientHelper.put((NormalizedSimpleStack)nssGas, gasRepresentation.getAmount());
                    ingredientHelper.put((NormalizedSimpleStack)nssItemOutput, -itemOutput.func_190916_E());
                    if (!ingredientHelper.addAsConversion((NormalizedSimpleStack)nssGasOutput, gasOutput.getAmount())) continue;
                    handled = true;
                }
            }
        }
        return handled;
    }
}

