/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.DataHandlerUtils;
import mekanism.api.annotations.NonNull;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ICachedRecipeHolder;
import mekanism.api.recipes.cache.ItemStackToItemStackCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.api.sustained.ISustainedInventory;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.entity.ai.RobitAIFollow;
import mekanism.common.entity.ai.RobitAIPickup;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemRobit;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismEntityTypes;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityRobit
extends CreatureEntity
implements IMekanismInventory,
ISustainedInventory,
ICachedRecipeHolder<ItemStackToItemStackRecipe>,
IMekanismStrictEnergyHandler {
    private static final DataParameter<String> OWNER_UUID = EntityDataManager.func_187226_a(EntityRobit.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> OWNER_NAME = EntityDataManager.func_187226_a(EntityRobit.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> FOLLOW = EntityDataManager.func_187226_a(EntityRobit.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DROP_PICKUP = EntityDataManager.func_187226_a(EntityRobit.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final FloatingLong MAX_ENERGY = FloatingLong.createConst(100000L);
    private static final FloatingLong DISTANCE_MULTIPLIER = FloatingLong.createConst(1.5);
    public Coord4D homeLocation;
    public boolean texTick;
    private int progress;
    private final int ticksRequired = 100;
    private CachedRecipe<ItemStackToItemStackRecipe> cachedRecipe = null;
    private final IInputHandler<@NonNull ItemStack> inputHandler;
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    @Nonnull
    private final List<IInventorySlot> inventorySlots;
    @Nonnull
    private final List<IInventorySlot> mainContainerSlots;
    @Nonnull
    private final List<IInventorySlot> smeltingContainerSlots;
    @Nonnull
    private final List<IInventorySlot> inventoryContainerSlots;
    private final EnergyInventorySlot energySlot;
    private final InputInventorySlot smeltingInputSlot;
    private final OutputInventorySlot smeltingOutputSlot;
    private final List<IEnergyContainer> energyContainers;
    private final BasicEnergyContainer energyContainer;

    public EntityRobit(EntityType<EntityRobit> type, World world) {
        super(type, world);
        this.getNavigator().func_212239_d(false);
        this.func_174805_g(true);
        this.energyContainer = BasicEnergyContainer.input(MAX_ENERGY, this);
        this.energyContainers = Collections.singletonList(this.energyContainer);
        this.inventorySlots = new ArrayList<IInventorySlot>();
        this.inventoryContainerSlots = new ArrayList<IInventorySlot>();
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                BasicInventorySlot slot = BasicInventorySlot.at(this, 8 + slotX * 18, 18 + slotY * 18);
                this.inventorySlots.add(slot);
                this.inventoryContainerSlots.add(slot);
            }
        }
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((EntityRobit)this).func_130014_f_(), this, 153, 17);
        this.inventorySlots.add(this.energySlot);
        this.smeltingInputSlot = InputInventorySlot.at(item -> this.containsRecipe(recipe -> recipe.getInput().testType(item)), this, 51, 35);
        this.inventorySlots.add(this.smeltingInputSlot);
        this.smeltingOutputSlot = OutputInventorySlot.at(this, 116, 35);
        this.inventorySlots.add(this.smeltingOutputSlot);
        this.mainContainerSlots = Collections.singletonList(this.energySlot);
        this.smeltingContainerSlots = Arrays.asList(this.smeltingInputSlot, this.smeltingOutputSlot);
        this.inputHandler = InputHelper.getInputHandler(this.smeltingInputSlot);
        this.outputHandler = OutputHelper.getOutputHandler(this.smeltingOutputSlot);
    }

    public EntityRobit(World world, double x, double y, double z) {
        this(MekanismEntityTypes.ROBIT.getEntityType(), world);
        this.func_70107_b(x, y, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    @Nonnull
    public GroundPathNavigator getNavigator() {
        return (GroundPathNavigator)this.field_70699_by;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new RobitAIPickup(this, 1.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new RobitAIFollow(this, 1.0f, 4.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal((MobEntity)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UUID, (Object)"");
        this.field_70180_af.func_187214_a(OWNER_NAME, (Object)"");
        this.field_70180_af.func_187214_a(FOLLOW, (Object)false);
        this.field_70180_af.func_187214_a(DROP_PICKUP, (Object)false);
    }

    private FloatingLong getRoundedTravelEnergy() {
        return DISTANCE_MULTIPLIER.multiply(Math.sqrt(this.func_70092_e(this.field_70169_q, this.field_70167_r, this.field_70166_s)));
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K && this.getFollowing() && this.getOwner() != null && this.func_70068_e((Entity)this.getOwner()) > 4.0 && !this.getNavigator().func_75500_f() && !this.energyContainer.isEmpty()) {
            this.energyContainer.extract(this.getRoundedTravelEnergy(), Action.EXECUTE, AutomationType.INTERNAL);
        }
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            BlockPos homePos;
            ServerWorld serverWorld;
            if (this.getDropPickup()) {
                this.collectItems();
            }
            if (this.homeLocation == null) {
                this.func_70106_y();
                return;
            }
            if (this.field_70173_aa % 20 == 0 && (serverWorld = ServerLifecycleHooks.getCurrentServer().func_71218_a(this.homeLocation.dimension)).func_195588_v(homePos = this.homeLocation.getPos()) && MekanismUtils.getTileEntity(TileEntityChargepad.class, (IBlockReader)serverWorld, homePos) == null) {
                this.drop();
                this.func_70106_y();
            }
            if (this.energyContainer.isEmpty() && !this.isOnChargepad()) {
                this.goHome();
            }
            this.energySlot.fillContainerOrConvert();
            this.cachedRecipe = this.getUpdatedCache(0);
            if (this.cachedRecipe != null) {
                this.cachedRecipe.process();
            }
        }
    }

    private void collectItems() {
        List items = this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(1.5, 1.5, 1.5));
        if (!items.isEmpty()) {
            block0: for (ItemEntity item : items) {
                if (item.func_174874_s() || item.func_92059_d().func_77973_b() instanceof ItemRobit || !item.func_70089_S()) continue;
                for (IInventorySlot slot : this.inventoryContainerSlots) {
                    if (slot.isEmpty()) {
                        slot.setStack(item.func_92059_d());
                        this.func_71001_a((Entity)item, item.func_92059_d().func_190916_E());
                        item.func_70106_y();
                        this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        continue block0;
                    }
                    ItemStack itemStack = slot.getStack();
                    int maxSize = slot.getLimit(itemStack);
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)itemStack, (ItemStack)item.func_92059_d()) || itemStack.func_190916_E() >= maxSize) continue;
                    int needed = maxSize - itemStack.func_190916_E();
                    int toAdd = Math.min(needed, item.func_92059_d().func_190916_E());
                    if (slot.growStack(toAdd, Action.EXECUTE) != toAdd) {
                        // empty if block
                    }
                    item.func_92059_d().func_190918_g(toAdd);
                    this.func_71001_a((Entity)item, toAdd);
                    if (item.func_92059_d().func_190926_b()) {
                        item.func_70106_y();
                    }
                    this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    continue block0;
                }
            }
        }
    }

    public void goHome() {
        this.setFollowing(false);
        if (this.field_71093_bK != this.homeLocation.dimension) {
            this.changeDimension(this.homeLocation.dimension, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    Entity repositionedEntity = repositionEntity.apply(false);
                    repositionedEntity.func_70634_a((double)EntityRobit.this.homeLocation.x + 0.5, (double)EntityRobit.this.homeLocation.y + 0.3, (double)EntityRobit.this.homeLocation.z + 0.5);
                    return repositionedEntity;
                }
            });
        } else {
            this.func_70634_a((double)this.homeLocation.x + 0.5, (double)this.homeLocation.y + 0.3, (double)this.homeLocation.z + 0.5);
        }
        this.func_213293_j(0.0, 0.0, 0.0);
    }

    private boolean isOnChargepad() {
        return MekanismUtils.getTileEntity(TileEntityChargepad.class, (IBlockReader)this.field_70170_p, this.func_180425_c()) != null;
    }

    @Nonnull
    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator) {
                if (!this.field_70170_p.field_72995_K) {
                    this.drop();
                }
                this.func_70106_y();
                player.func_184609_a(hand);
                return ActionResultType.SUCCESS;
            }
        } else {
            Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedEntityButton.ROBIT_MAIN, this.func_145782_y()));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void drop() {
        IStrictEnergyHandler energyHandlerItem;
        ItemEntity entityItem = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.3, this.func_226281_cx_(), MekanismItems.ROBIT.getItemStack());
        ItemStack stack = entityItem.func_92059_d();
        Optional capability = MekanismUtils.toOptional(stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY));
        if (capability.isPresent() && (energyHandlerItem = (IStrictEnergyHandler)capability.get()).getEnergyContainerCount() > 0) {
            energyHandlerItem.setEnergy(0, this.energyContainer.getEnergy());
        }
        ItemRobit item = (ItemRobit)stack.func_77973_b();
        item.setInventory(this.getInventory(new Object[0]), new Object[]{stack});
        item.setName(stack, this.func_200200_C_().func_150254_d());
        entityItem.func_213293_j(0.0, this.field_70146_Z.nextGaussian() * (double)0.05f + (double)0.2f, 0.0);
        this.field_70170_p.func_217376_c((Entity)entityItem);
    }

    public double getScaledProgress() {
        return (double)this.getOperatingTicks() / 100.0;
    }

    public int getOperatingTicks() {
        return this.progress;
    }

    @Override
    public int getSavedOperatingTicks(int cacheIndex) {
        return this.getOperatingTicks();
    }

    public void func_213281_b(CompoundNBT nbtTags) {
        super.func_213281_b(nbtTags);
        if (this.getOwnerUUID() != null) {
            nbtTags.func_186854_a("owner", this.getOwnerUUID());
        }
        nbtTags.func_74757_a("follow", this.getFollowing());
        nbtTags.func_74757_a("dropPickup", this.getDropPickup());
        if (this.homeLocation != null) {
            this.homeLocation.write(nbtTags);
        }
        nbtTags.func_218657_a("Items", (INBT)DataHandlerUtils.writeSlots(this.getInventorySlots(null)));
        nbtTags.func_218657_a("EnergyContainers", (INBT)DataHandlerUtils.writeContainers(this.getEnergyContainers(null)));
        nbtTags.func_74768_a("progress", this.getOperatingTicks());
    }

    public void func_70037_a(CompoundNBT nbtTags) {
        super.func_70037_a(nbtTags);
        NBTUtils.setUUIDIfPresent(nbtTags, "owner", this::setOwnerUUID);
        this.setFollowing(nbtTags.func_74767_n("follow"));
        this.setDropPickup(nbtTags.func_74767_n("dropPickup"));
        this.homeLocation = Coord4D.read(nbtTags);
        DataHandlerUtils.readSlots(this.getInventorySlots(null), nbtTags.func_150295_c("Items", 10));
        DataHandlerUtils.readContainers(this.getEnergyContainers(null), nbtTags.func_150295_c("EnergyContainers", 10));
        this.progress = nbtTags.func_74762_e("progress");
    }

    protected void func_70665_d(@Nonnull DamageSource damageSource, float amount) {
        if ((amount = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)damageSource, (float)amount)) <= 0.0f) {
            return;
        }
        amount = this.func_70655_b(damageSource, amount);
        amount = this.func_70672_c(damageSource, amount);
        float j = this.func_110143_aJ();
        this.energyContainer.extract(FloatingLong.create(1000.0f * amount), Action.EXECUTE, AutomationType.INTERNAL);
        this.func_110142_aN().func_94547_a(damageSource, j, amount);
    }

    protected void func_70609_aI() {
    }

    public void setHome(Coord4D home) {
        this.homeLocation = home;
    }

    public boolean func_70104_M() {
        return !this.energyContainer.isEmpty();
    }

    public PlayerEntity getOwner() {
        return this.field_70170_p.func_217371_b(this.getOwnerUUID());
    }

    public String getOwnerName() {
        return (String)this.field_70180_af.func_187225_a(OWNER_NAME);
    }

    public UUID getOwnerUUID() {
        return UUID.fromString((String)this.field_70180_af.func_187225_a(OWNER_UUID));
    }

    public void setOwnerUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UUID, (Object)uuid.toString());
        this.field_70180_af.func_187227_b(OWNER_NAME, (Object)MekanismUtils.getLastKnownUsername(uuid));
    }

    public boolean getFollowing() {
        return (Boolean)this.field_70180_af.func_187225_a(FOLLOW);
    }

    public void setFollowing(boolean follow) {
        this.field_70180_af.func_187227_b(FOLLOW, (Object)follow);
    }

    public boolean getDropPickup() {
        return (Boolean)this.field_70180_af.func_187225_a(DROP_PICKUP);
    }

    public void setDropPickup(boolean pickup) {
        this.field_70180_af.func_187227_b(DROP_PICKUP, (Object)pickup);
    }

    @Override
    public void setInventory(ListNBT nbtTags, Object ... data) {
        if (nbtTags != null && !nbtTags.isEmpty()) {
            DataHandlerUtils.readSlots(this.getInventorySlots(null), nbtTags);
        }
    }

    @Override
    public ListNBT getInventory(Object ... data) {
        return DataHandlerUtils.writeSlots(this.getInventorySlots(null));
    }

    @Override
    @Nonnull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.hasInventory() ? this.inventorySlots : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.canHandleEnergy() ? this.energyContainers : Collections.emptyList();
    }

    @Override
    public void onContentsChanged() {
    }

    @Nonnull
    public List<IInventorySlot> getContainerInventorySlots(@Nonnull ContainerType<?> containerType) {
        if (!this.hasInventory()) {
            return Collections.emptyList();
        }
        if (containerType == MekanismContainerTypes.INVENTORY_ROBIT.getContainerType()) {
            return this.inventoryContainerSlots;
        }
        if (containerType == MekanismContainerTypes.MAIN_ROBIT.getContainerType()) {
            return this.mainContainerSlots;
        }
        if (containerType == MekanismContainerTypes.SMELTING_ROBIT.getContainerType()) {
            return this.smeltingContainerSlots;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public MekanismRecipeType<ItemStackToItemStackRecipe> getRecipeType() {
        return MekanismRecipeType.SMELTING;
    }

    public boolean containsRecipe(@Nonnull Predicate<ItemStackToItemStackRecipe> matchCriteria) {
        return this.getRecipeType().contains(this.func_130014_f_(), matchCriteria);
    }

    @Nullable
    public ItemStackToItemStackRecipe findFirstRecipe(@Nonnull Predicate<ItemStackToItemStackRecipe> matchCriteria) {
        return this.getRecipeType().findFirst(this.func_130014_f_(), matchCriteria);
    }

    @Override
    @Nullable
    public CachedRecipe<ItemStackToItemStackRecipe> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipe;
    }

    @Override
    @Nullable
    public ItemStackToItemStackRecipe getRecipe(int cacheIndex) {
        ItemStack stack = this.inputHandler.getInput();
        return stack.func_190926_b() ? null : this.findFirstRecipe(recipe -> recipe.test(stack));
    }

    public IEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    @Nullable
    public CachedRecipe<ItemStackToItemStackRecipe> createNewCachedRecipe(@Nonnull ItemStackToItemStackRecipe recipe, int cacheIndex) {
        return new ItemStackToItemStackCachedRecipe(recipe, this.inputHandler, this.outputHandler).setEnergyRequirements(MekanismConfig.usage.energizedSmelter, this.energyContainer).setRequiredTicks(() -> 100).setOnFinish(this::onContentsChanged).setOperatingTicksChanged(operatingTicks -> {
            this.progress = operatingTicks;
        });
    }

    public void addContainerTrackers(@Nonnull ContainerType<?> containerType, MekanismContainer container) {
        if (containerType == MekanismContainerTypes.MAIN_ROBIT.getContainerType()) {
            container.track(SyncableFloatingLong.create(this.energyContainer::getEnergy, this.energyContainer::setEnergy));
        } else if (containerType == MekanismContainerTypes.SMELTING_ROBIT.getContainerType()) {
            container.track(SyncableInt.create(() -> this.progress, value -> {
                this.progress = value;
            }));
        }
    }
}

