/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.distribution.target;

import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.distribution.SplitInfo;
import mekanism.common.distribution.target.Target;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.transmitters.grid.EnergyNetwork;
import net.minecraft.util.Direction;

public class EnergyTransmitterSaveTarget
extends Target<IGridTransmitter<IStrictEnergyHandler, EnergyNetwork, FloatingLong>, FloatingLong, FloatingLong> {
    private FloatingLong currentStored = FloatingLong.ZERO;

    @Override
    protected void acceptAmount(IGridTransmitter<IStrictEnergyHandler, EnergyNetwork, FloatingLong> transmitter, SplitInfo<FloatingLong> splitInfo, FloatingLong amount) {
        amount = amount.min(transmitter.getCapacityAsFloatingLong().subtract(this.currentStored));
        this.currentStored = this.currentStored.plusEqual(amount);
        splitInfo.send(amount);
    }

    @Override
    protected FloatingLong simulate(IGridTransmitter<IStrictEnergyHandler, EnergyNetwork, FloatingLong> transmitter, FloatingLong energyToSend) {
        return energyToSend.copy().min(transmitter.getCapacityAsFloatingLong().subtract(this.currentStored));
    }

    public void saveShare(Direction handlerDirection) {
        TileEntityTransmitter tile;
        IGridTransmitter transmitter = (IGridTransmitter)this.handlers.get(handlerDirection);
        if (transmitter instanceof TransmitterImpl && (tile = ((TransmitterImpl)transmitter).getTileEntity()) instanceof TileEntityUniversalCable) {
            TileEntityUniversalCable cable = (TileEntityUniversalCable)tile;
            if (!this.currentStored.isZero() || !cable.lastWrite.isZero()) {
                cable.lastWrite = this.currentStored;
                cable.markDirty(false);
            }
        }
    }
}

