/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.distribution;

import mekanism.api.math.FloatingLong;
import mekanism.common.distribution.SplitInfo;

public class FloatingLongSplitInfo
extends SplitInfo<FloatingLong> {
    private FloatingLong amountToSplit;
    private FloatingLong amountPerTarget;
    private FloatingLong sentSoFar;

    public FloatingLongSplitInfo(FloatingLong amountToSplit, int totalTargets) {
        super(totalTargets);
        this.amountToSplit = amountToSplit.copy();
        this.amountPerTarget = this.toSplitAmong == 0 ? FloatingLong.ZERO : amountToSplit.divide(this.toSplitAmong);
        this.sentSoFar = FloatingLong.ZERO;
    }

    @Override
    public void send(FloatingLong amountNeeded) {
        this.amountToSplit = this.amountToSplit.minusEqual(amountNeeded);
        this.sentSoFar = this.sentSoFar.plusEqual(amountNeeded);
        --this.toSplitAmong;
        if (!amountNeeded.equals(this.amountPerTarget) && this.toSplitAmong != 0) {
            FloatingLong amountPerLast = this.amountPerTarget;
            this.amountPerTarget = this.amountToSplit.divide(this.toSplitAmong);
            if (!this.amountPerChanged && !this.amountPerTarget.equals(amountPerLast)) {
                this.amountPerChanged = true;
            }
        }
    }

    @Override
    public FloatingLong getShareAmount() {
        return this.amountPerTarget;
    }

    @Override
    public FloatingLong getRemainderAmount() {
        return this.amountPerTarget;
    }

    @Override
    public FloatingLong getTotalSent() {
        return this.sentSoFar;
    }
}

