/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.DataHandlerUtils;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.multiblock.MultiblockCache;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;

public class BoilerCache
extends MultiblockCache<SynchronizedBoilerData>
implements IMekanismFluidHandler,
IMekanismGasHandler,
IMekanismHeatHandler {
    private final List<IExtendedFluidTank> fluidTanks = Collections.singletonList(BasicFluidTank.create(Integer.MAX_VALUE, this));
    private final List<IGasTank> gasTanks = Collections.singletonList(BasicGasTank.create(Long.MAX_VALUE, this));
    public final List<IHeatCapacitor> heatCapacitors = Collections.singletonList(BasicHeatCapacitor.create(1.0, this));

    @Override
    public void apply(SynchronizedBoilerData data) {
        data.setFluidTankData(this.fluidTanks);
        data.setGasTankData(this.gasTanks);
        data.setHeatCapacitorData(this.heatCapacitors);
    }

    @Override
    public void sync(SynchronizedBoilerData data) {
        List<IExtendedFluidTank> fluidTanksToCopy = data.getFluidTanks(null);
        for (int i = 0; i < fluidTanksToCopy.size(); ++i) {
            if (i >= this.fluidTanks.size()) continue;
            this.fluidTanks.get(i).setStack(fluidTanksToCopy.get(i).getFluid());
        }
        List<IGasTank> gasTanksToCopy = data.getGasTanks(null);
        for (int i = 0; i < gasTanksToCopy.size(); ++i) {
            if (i >= this.gasTanks.size()) continue;
            this.gasTanks.get(i).setStack(gasTanksToCopy.get(i).getStack());
        }
        List<IHeatCapacitor> heatCapacitorsToCopy = data.getHeatCapacitors(null);
        for (int i = 0; i < heatCapacitorsToCopy.size(); ++i) {
            if (i >= this.heatCapacitors.size()) continue;
            this.heatCapacitors.get(i).setHeat(heatCapacitorsToCopy.get(i).getHeat());
            if (!(this.heatCapacitors.get(i) instanceof BasicHeatCapacitor)) continue;
            ((BasicHeatCapacitor)this.heatCapacitors.get(i)).setHeatCapacity(heatCapacitorsToCopy.get(i).getHeatCapacity(), false);
        }
    }

    @Override
    public void load(CompoundNBT nbtTags) {
        DataHandlerUtils.readTanks(this.getFluidTanks(null), nbtTags.func_150295_c("FluidTanks", 10));
        DataHandlerUtils.readTanks(this.getGasTanks(null), nbtTags.func_150295_c("GasTanks", 10));
        DataHandlerUtils.readContainers(this.getHeatCapacitors(null), nbtTags.func_150295_c("HeatCapacitors", 10));
    }

    @Override
    public void save(CompoundNBT nbtTags) {
        nbtTags.func_218657_a("FluidTanks", (INBT)DataHandlerUtils.writeTanks(this.getFluidTanks(null)));
        nbtTags.func_218657_a("GasTanks", (INBT)DataHandlerUtils.writeTanks(this.getGasTanks(null)));
        nbtTags.func_218657_a("HeatCapacitors", (INBT)DataHandlerUtils.writeContainers(this.getHeatCapacitors(null)));
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    @Nonnull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Override
    @Nonnull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.heatCapacitors;
    }

    @Override
    public void onContentsChanged() {
    }
}

