/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.blocktype;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.common.base.ILangEntry;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeCustomShape;
import mekanism.common.block.interfaces.ITypeBlock;
import mekanism.common.content.blocktype.BlockTypeTile;
import net.minecraft.block.Block;
import net.minecraft.util.math.shapes.VoxelShape;

public class BlockType {
    private ILangEntry description;
    private Map<Class<? extends Attribute>, Attribute> attributeMap = new HashMap<Class<? extends Attribute>, Attribute>();

    public BlockType(ILangEntry description) {
        this.description = description;
    }

    public boolean has(Class<? extends Attribute> type) {
        return this.attributeMap.containsKey(type);
    }

    public <T extends Attribute> T get(Class<T> type) {
        return (T)this.attributeMap.get(type);
    }

    @SafeVarargs
    protected final void setFrom(BlockTypeTile<?> tile, Class<? extends Attribute> ... types) {
        for (Class<? extends Attribute> type : types) {
            this.attributeMap.put(type, tile.get(type));
        }
    }

    public void add(Attribute ... attrs) {
        for (Attribute attr : attrs) {
            this.attributeMap.put(attr.getClass(), attr);
        }
    }

    @SafeVarargs
    public final void remove(Class<? extends Attribute> ... attrs) {
        for (Class<? extends Attribute> attr : attrs) {
            this.attributeMap.remove(attr);
        }
    }

    @Nonnull
    public ILangEntry getDescription() {
        return this.description;
    }

    public static boolean is(Block block, BlockType ... types) {
        if (block instanceof ITypeBlock) {
            for (BlockType type : types) {
                if (((ITypeBlock)block).getType() != type) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockType get(Block block) {
        return block instanceof ITypeBlock ? ((ITypeBlock)block).getType() : null;
    }

    public static class BlockTypeBuilder<BLOCK extends BlockType, T extends BlockTypeBuilder<BLOCK, T>> {
        protected BLOCK holder;

        protected BlockTypeBuilder(BLOCK holder) {
            this.holder = holder;
        }

        public static BlockTypeBuilder<BlockType, ?> createBlock(ILangEntry description) {
            return new BlockTypeBuilder(new BlockType(description));
        }

        public T getThis() {
            return (T)this;
        }

        public T with(Attribute ... attrs) {
            ((BlockType)this.holder).add(attrs);
            return this.getThis();
        }

        @SafeVarargs
        public final T without(Class<? extends Attribute> ... attrs) {
            ((BlockType)this.holder).remove(attrs);
            return this.getThis();
        }

        public T withCustomShape(VoxelShape[] shape) {
            return this.with(new AttributeCustomShape(shape));
        }

        public BLOCK build() {
            return this.holder;
        }
    }
}

