/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.assemblicator;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class RecipeFormula {
    public NonNullList<ItemStack> input = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    @Nullable
    public ICraftingRecipe recipe;
    private CraftingInventory dummy = MekanismUtils.getDummyCraftingInv();

    public RecipeFormula(World world, NonNullList<ItemStack> inv) {
        for (int i = 0; i < 9; ++i) {
            this.input.set(i, (Object)StackUtils.size((ItemStack)inv.get(i), 1));
        }
        this.resetToRecipe();
        this.recipe = RecipeFormula.getRecipeFromGrid(this.dummy, world);
    }

    public RecipeFormula(World world, List<IInventorySlot> craftingGridSlots) {
        for (int i = 0; i < craftingGridSlots.size(); ++i) {
            IInventorySlot craftingSlot = craftingGridSlots.get(i);
            if (craftingSlot.isEmpty()) continue;
            this.input.set(i, (Object)StackUtils.size(craftingSlot.getStack(), 1));
        }
        this.resetToRecipe();
        this.recipe = RecipeFormula.getRecipeFromGrid(this.dummy, world);
    }

    private void resetToRecipe() {
        for (int i = 0; i < 9; ++i) {
            this.dummy.func_70299_a(i, (ItemStack)this.input.get(i));
        }
    }

    public boolean matches(World world, List<IInventorySlot> craftingGridSlots) {
        if (this.recipe == null) {
            return false;
        }
        for (int i = 0; i < craftingGridSlots.size(); ++i) {
            this.dummy.func_70299_a(i, StackUtils.size(craftingGridSlots.get(i).getStack(), 1));
        }
        return this.recipe.func_77569_a((IInventory)this.dummy, world);
    }

    public boolean isIngredientInPos(World world, ItemStack stack, int i) {
        if (this.recipe == null) {
            return false;
        }
        this.resetToRecipe();
        this.dummy.func_70299_a(i, stack);
        return this.recipe.func_77569_a((IInventory)this.dummy, world);
    }

    public IntList getIngredientIndices(World world, ItemStack stack) {
        IntArrayList ret = new IntArrayList();
        if (this.recipe != null) {
            for (int i = 0; i < 9; ++i) {
                this.dummy.func_70299_a(i, stack);
                if (this.recipe.func_77569_a((IInventory)this.dummy, world)) {
                    ret.add(i);
                }
                this.dummy.func_70299_a(i, (ItemStack)this.input.get(i));
            }
        }
        return ret;
    }

    public boolean isValidFormula() {
        return this.getRecipe() != null;
    }

    @Nullable
    public ICraftingRecipe getRecipe() {
        return this.recipe;
    }

    public boolean isFormulaEqual(RecipeFormula formula) {
        return formula.getRecipe() == this.getRecipe();
    }

    public void setStack(World world, int index, ItemStack stack) {
        this.input.set(index, (Object)stack);
        this.resetToRecipe();
        this.recipe = RecipeFormula.getRecipeFromGrid(this.dummy, world);
    }

    @Nullable
    private static ICraftingRecipe getRecipeFromGrid(CraftingInventory inv, World world) {
        return world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)inv, world).orElse(null);
    }
}

