/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.fluid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.capabilities.holder.ConfigHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import net.minecraft.util.Direction;

public class ConfigFluidTankHolder
extends ConfigHolder
implements IFluidTankHolder {
    protected final List<IExtendedFluidTank> tanks = new ArrayList<IExtendedFluidTank>();

    public ConfigFluidTankHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        super(facingSupplier, configSupplier);
    }

    void addTank(@Nonnull IExtendedFluidTank tank) {
        this.tanks.add(tank);
    }

    @Override
    protected TransmissionType getTransmissionType() {
        return TransmissionType.FLUID;
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getTanks(@Nullable Direction direction) {
        if (direction == null) {
            return this.tanks;
        }
        TileComponentConfig config = (TileComponentConfig)this.configSupplier.get();
        if (config == null) {
            return this.tanks;
        }
        ConfigInfo configInfo = config.getConfig(this.getTransmissionType());
        if (configInfo == null) {
            return this.tanks;
        }
        RelativeSide side = RelativeSide.fromDirections((Direction)this.facingSupplier.get(), direction);
        ISlotInfo slotInfo = configInfo.getSlotInfo(side);
        if (slotInfo instanceof FluidSlotInfo && slotInfo.isEnabled()) {
            return ((FluidSlotInfo)slotInfo).getTanks();
        }
        return Collections.emptyList();
    }
}

