/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.fluid;

import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidTankFluidTank
extends BasicFluidTank {
    private final TileEntityFluidTank tile;
    private final boolean isCreative;
    private final IntSupplier rate;

    public static FluidTankFluidTank create(TileEntityFluidTank tile) {
        Objects.requireNonNull(tile, "Fluid tank tile entity cannot be null");
        return new FluidTankFluidTank(tile);
    }

    private FluidTankFluidTank(TileEntityFluidTank tile) {
        super(tile.tier.getStorage(), alwaysTrueBi, alwaysTrueBi, (Predicate<FluidStack>)alwaysTrue, (IMekanismFluidHandler)tile);
        this.tile = tile;
        this.rate = tile.tier::getOutput;
        this.isCreative = tile.tier == FluidTankTier.CREATIVE;
    }

    @Override
    protected int getRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsInt() : super.getRate(automationType);
    }

    @Override
    public FluidStack insert(FluidStack stack, Action action, AutomationType automationType) {
        TileEntityFluidTank tileAbove;
        FluidStack remainder;
        if (this.isCreative && this.isEmpty() && action.execute() && automationType != AutomationType.EXTERNAL) {
            remainder = super.insert(stack, Action.SIMULATE, automationType);
            if (remainder.isEmpty()) {
                this.setStackUnchecked(new FluidStack(stack, this.getCapacity()));
            }
        } else {
            remainder = super.insert(stack, action.combine(!this.isCreative), automationType);
        }
        if (!remainder.isEmpty() && (tileAbove = MekanismUtils.getTileEntity(TileEntityFluidTank.class, (IBlockReader)this.tile.func_145831_w(), this.tile.func_174877_v().func_177984_a())) != null) {
            remainder = tileAbove.fluidTank.insert(remainder, action, AutomationType.EXTERNAL);
        }
        return remainder;
    }

    @Override
    public int growStack(int amount, Action action) {
        TileEntityFluidTank tileAbove;
        int grownAmount = super.growStack(amount, action);
        if (amount > 0 && grownAmount < amount && !this.tile.getActive() && (tileAbove = MekanismUtils.getTileEntity(TileEntityFluidTank.class, (IBlockReader)this.tile.func_145831_w(), this.tile.func_174877_v().func_177984_a())) != null) {
            int leftOverToInsert = amount - grownAmount;
            FluidStack remainder = tileAbove.fluidTank.insert(new FluidStack(this.stored, leftOverToInsert), action, AutomationType.EXTERNAL);
            grownAmount += leftOverToInsert - remainder.getAmount();
        }
        return grownAmount;
    }

    @Override
    public FluidStack extract(int amount, Action action, AutomationType automationType) {
        return super.extract(amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    public int setStackSize(int amount, Action action) {
        return super.setStackSize(amount, action.combine(!this.isCreative));
    }
}

