/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.infuse.BasicInfusionTank;
import mekanism.api.chemical.infuse.IMekanismInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.inventory.AutomationType;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VariableCapacityInfusionTank
extends BasicInfusionTank {
    private final LongSupplier capacity;

    public static VariableCapacityInfusionTank create(LongSupplier capacity, BiPredicate<@NonNull InfuseType, @NonNull AutomationType> canExtract, BiPredicate<@NonNull InfuseType, @NonNull AutomationType> canInsert, Predicate<@NonNull InfuseType> validator, @Nullable IMekanismInfusionHandler infusionHandler) {
        Objects.requireNonNull(capacity, "Capacity supplier cannot be null");
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Infuse type validity check cannot be null");
        return new VariableCapacityInfusionTank(capacity, canExtract, canInsert, validator, infusionHandler);
    }

    public static VariableCapacityInfusionTank output(LongSupplier capacity, Predicate<@NonNull InfuseType> validator, @Nullable IMekanismInfusionHandler infusionHandler) {
        Objects.requireNonNull(capacity, "Capacity supplier cannot be null");
        Objects.requireNonNull(validator, "Infuse type validity check cannot be null");
        return new VariableCapacityInfusionTank(capacity, (BiPredicate<InfuseType, AutomationType>)alwaysTrueBi, (BiPredicate<InfuseType, AutomationType>)internalOnly, validator, infusionHandler);
    }

    protected VariableCapacityInfusionTank(LongSupplier capacity, BiPredicate<@NonNull InfuseType, @NonNull AutomationType> canExtract, BiPredicate<@NonNull InfuseType, @NonNull AutomationType> canInsert, Predicate<@NonNull InfuseType> validator, @Nullable IMekanismInfusionHandler infusionHandler) {
        super(capacity.getAsLong(), canExtract, canInsert, validator, infusionHandler);
        this.capacity = capacity;
    }

    @Override
    public long getCapacity() {
        return this.capacity.getAsLong();
    }

    @Override
    public long setStackSize(long amount, @Nonnull Action action) {
        if (this.isEmpty()) {
            return 0L;
        }
        if (amount <= 0L) {
            if (action.execute()) {
                this.setStack(this.getEmptyStack());
            }
            return 0L;
        }
        long maxStackSize = this.getCapacity();
        if (maxStackSize > 0L && amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getStored() == amount || action.simulate()) {
            return amount;
        }
        ((InfusionStack)this.stored).setAmount(amount);
        this.onContentsChanged();
        return amount;
    }
}

