/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.states;

import mekanism.api.math.MathUtils;
import mekanism.api.transmitters.TransmissionType;

public enum TransmitterType {
    UNIVERSAL_CABLE(Size.SMALL, TransmissionType.ENERGY),
    MECHANICAL_PIPE(Size.LARGE, TransmissionType.FLUID),
    PRESSURIZED_TUBE(Size.SMALL, TransmissionType.GAS),
    LOGISTICAL_TRANSPORTER(Size.LARGE, TransmissionType.ITEM),
    RESTRICTIVE_TRANSPORTER(Size.LARGE, TransmissionType.ITEM),
    DIVERSION_TRANSPORTER(Size.LARGE, TransmissionType.ITEM),
    THERMODYNAMIC_CONDUCTOR(Size.SMALL, TransmissionType.HEAT);

    private static final TransmitterType[] TYPES;
    private final Size size;
    private final TransmissionType transmissionType;

    private TransmitterType(Size size, TransmissionType type) {
        this.size = size;
        this.transmissionType = type;
    }

    public Size getSize() {
        return this.size;
    }

    public TransmissionType getTransmission() {
        return this.transmissionType;
    }

    public static TransmitterType byIndexStatic(int index) {
        return MathUtils.getByIndexMod(TYPES, index);
    }

    static {
        TYPES = TransmitterType.values();
    }

    public static enum Size {
        SMALL(6),
        LARGE(8);

        public int centerSize;

        private Size(int size) {
            this.centerSize = size;
        }
    }
}

