/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import mekanism.client.render.obj.OpaqueModelConfiguration;
import mekanism.client.render.obj.TransmitterBakedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.geometry.IMultipartModelGeometry;
import net.minecraftforge.client.model.obj.OBJModel;

public class TransmitterModel
implements IMultipartModelGeometry<TransmitterModel> {
    private final OBJModel internal;
    @Nullable
    private final OBJModel glass;

    public TransmitterModel(OBJModel internalModel, @Nullable OBJModel glass) {
        this.internal = internalModel;
        this.glass = glass;
    }

    public Collection<? extends IModelGeometryPart> getParts() {
        return this.internal.getParts();
    }

    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return this.internal.getPart(name);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        return new TransmitterBakedModel(this.internal, this.glass, owner, bakery, spriteGetter, modelTransform, overrides, modelLocation);
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet combined = Sets.newHashSet();
        OpaqueModelConfiguration configuration = new OpaqueModelConfiguration(owner);
        for (IModelGeometryPart iModelGeometryPart : this.getParts()) {
            combined.addAll(iModelGeometryPart.getTextures(owner, modelGetter, missingTextureErrors));
            combined.addAll(iModelGeometryPart.getTextures((IModelConfiguration)configuration, modelGetter, missingTextureErrors));
        }
        if (this.glass != null) {
            for (IModelGeometryPart iModelGeometryPart : this.glass.getParts()) {
                combined.addAll(iModelGeometryPart.getTextures(owner, modelGetter, missingTextureErrors));
                combined.addAll(iModelGeometryPart.getTextures((IModelConfiguration)configuration, modelGetter, missingTextureErrors));
            }
        }
        return combined;
    }
}

