/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import java.util.Arrays;
import java.util.UUID;
import mekanism.api.text.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.network.PacketSecurityMode;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;

public class GuiSecurityTab<TILE extends TileEntity>
extends GuiInsetElement<TILE> {
    private static final ResourceLocation PUBLIC = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "public.png");
    private static final ResourceLocation PRIVATE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "private.png");
    private static final ResourceLocation PROTECTED = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "protected.png");
    private final Hand currentHand;
    private boolean isItem;

    public GuiSecurityTab(IGuiWrapper gui, TILE tile) {
        super(PUBLIC, gui, tile, gui.getWidth(), 32, 26, 18);
        this.currentHand = Hand.MAIN_HAND;
    }

    public GuiSecurityTab(IGuiWrapper gui, Hand hand) {
        super(PUBLIC, gui, null, gui.getWidth(), 32, 26, 18);
        this.isItem = true;
        this.currentHand = hand;
    }

    @Override
    protected void colorTab() {
        MekanismRenderer.color(-1529193);
    }

    @Override
    protected ResourceLocation getOverlay() {
        ISecurityTile.SecurityMode mode = this.getSecurity();
        SecurityData data = MekanismClient.clientSecurityMap.get(this.getOwner());
        if (data != null && data.override) {
            mode = data.mode;
        }
        switch (mode) {
            case PRIVATE: {
                return PRIVATE;
            }
            case TRUSTED: {
                return PROTECTED;
            }
        }
        return super.getOverlay();
    }

    public void renderToolTip(int mouseX, int mouseY) {
        ITextComponent securityComponent = MekanismLang.SECURITY.translateColored(EnumColor.GRAY, this.isItem ? SecurityUtils.getSecurity(this.getItem(), Dist.CLIENT) : SecurityUtils.getSecurity((ISecurityTile)this.tile, Dist.CLIENT));
        ITextComponent ownerComponent = OwnerDisplay.of((PlayerEntity)GuiSecurityTab.minecraft.field_71439_g, this.getOwner(), this.getOwnerUsername()).getTextComponent();
        if (this.isItem ? SecurityUtils.isOverridden(this.getItem(), Dist.CLIENT) : SecurityUtils.isOverridden(this.tile, Dist.CLIENT)) {
            this.displayTooltips(Arrays.asList(securityComponent, ownerComponent, MekanismLang.SECURITY_OVERRIDDEN.translateColored(EnumColor.RED, new Object[0])), mouseX, mouseY);
        } else {
            this.displayTooltips(Arrays.asList(securityComponent, ownerComponent), mouseX, mouseY);
        }
    }

    private ISecurityTile.SecurityMode getSecurity() {
        if (!MekanismConfig.general.allowProtection.get()) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        if (this.isItem) {
            ItemStack stack = this.getItem();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISecurityItem)) {
                GuiSecurityTab.minecraft.field_71439_g.func_71053_j();
                return ISecurityTile.SecurityMode.PUBLIC;
            }
            return ((ISecurityItem)stack.func_77973_b()).getSecurity(stack);
        }
        return ((ISecurityTile)this.tile).getSecurity().getMode();
    }

    private UUID getOwner() {
        if (this.isItem) {
            ItemStack stack = this.getItem();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISecurityItem)) {
                GuiSecurityTab.minecraft.field_71439_g.func_71053_j();
                return null;
            }
            return ((ISecurityItem)stack.func_77973_b()).getOwnerUUID(stack);
        }
        return ((ISecurityTile)this.tile).getSecurity().getOwnerUUID();
    }

    private String getOwnerUsername() {
        if (this.isItem) {
            ItemStack stack = this.getItem();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISecurityItem)) {
                GuiSecurityTab.minecraft.field_71439_g.func_71053_j();
                return null;
            }
            return MekanismClient.clientUUIDMap.get(((ISecurityItem)stack.func_77973_b()).getOwnerUUID(stack));
        }
        return ((ISecurityTile)this.tile).getSecurity().getClientOwner();
    }

    private ItemStack getItem() {
        return GuiSecurityTab.minecraft.field_71439_g.func_184586_b(this.currentHand);
    }

    public void onClick(double mouseX, double mouseY) {
        UUID owner;
        if (MekanismConfig.general.allowProtection.get() && (owner = this.getOwner()) != null && GuiSecurityTab.minecraft.field_71439_g.func_110124_au().equals(owner)) {
            if (this.isItem) {
                Mekanism.packetHandler.sendToServer(new PacketSecurityMode(this.currentHand, (ISecurityTile.SecurityMode)this.getSecurity().getNext()));
            } else {
                Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.NEXT_SECURITY_MODE, this.tile));
            }
        }
    }
}

