/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiTankGauge;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.network.PacketDropperUse;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class GuiFluidGauge
extends GuiTankGauge<FluidStack, IExtendedFluidTank> {
    public GuiFluidGauge(IFluidInfoHandler handler, GaugeType type, IGuiWrapper gui, int x, int y) {
        super(type, gui, x, y, handler, PacketDropperUse.TankType.FLUID_TANK);
        this.setDummyType(FluidStack.EMPTY);
    }

    public GuiFluidGauge(final Supplier<IExtendedFluidTank> tankSupplier, final Supplier<List<IExtendedFluidTank>> tanksSupplier, GaugeType type, IGuiWrapper gui, int x, int y) {
        this(new IFluidInfoHandler(){

            @Override
            @Nullable
            public IExtendedFluidTank getTank() {
                return (IExtendedFluidTank)tankSupplier.get();
            }

            @Override
            public int getTankIndex() {
                IExtendedFluidTank tank = this.getTank();
                return tank == null ? -1 : ((List)tanksSupplier.get()).indexOf(tank);
            }
        }, type, gui, x, y);
    }

    public static GuiFluidGauge getDummy(GaugeType type, IGuiWrapper gui, int x, int y) {
        GuiFluidGauge gauge = new GuiFluidGauge(null, type, gui, x, y);
        gauge.dummy = true;
        return gauge;
    }

    @Override
    public TransmissionType getTransmission() {
        return TransmissionType.FLUID;
    }

    @Override
    public int getScaledLevel() {
        if (this.dummy) {
            return this.height - 2;
        }
        IExtendedFluidTank tank = (IExtendedFluidTank)this.getTank();
        if (tank == null || tank.isEmpty() || tank.getCapacity() == 0) {
            return 0;
        }
        if (tank.getFluidAmount() == Integer.MAX_VALUE) {
            return this.height - 2;
        }
        float scale = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        return Math.round(scale * (float)(this.height - 2));
    }

    @Override
    public TextureAtlasSprite getIcon() {
        if (this.dummy || this.getTank() == null) {
            return MekanismRenderer.getFluidTexture((FluidStack)this.dummyType, MekanismRenderer.FluidType.STILL);
        }
        FluidStack fluid = ((IExtendedFluidTank)this.getTank()).getFluid();
        return MekanismRenderer.getFluidTexture(fluid.isEmpty() ? (FluidStack)this.dummyType : fluid, MekanismRenderer.FluidType.STILL);
    }

    @Override
    public ITextComponent getTooltipText() {
        if (this.dummy) {
            return TextComponentUtil.build(this.dummyType);
        }
        IExtendedFluidTank tank = (IExtendedFluidTank)this.getTank();
        if (tank == null || tank.isEmpty()) {
            return MekanismLang.EMPTY.translate(new Object[0]);
        }
        int amount = tank.getFluidAmount();
        FluidStack fluidStack = tank.getFluid();
        if (amount == Integer.MAX_VALUE) {
            return MekanismLang.GENERIC_STORED.translate(fluidStack, MekanismLang.INFINITE);
        }
        return MekanismLang.GENERIC_STORED_MB.translate(fluidStack, amount);
    }

    @Override
    protected void applyRenderColor() {
        MekanismRenderer.color(this.dummy || this.getTank() == null ? (FluidStack)this.dummyType : ((IExtendedFluidTank)this.getTank()).getFluid());
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return ((IExtendedFluidTank)this.getTank()).isEmpty() ? null : ((IExtendedFluidTank)this.getTank()).getFluid();
    }

    public static interface IFluidInfoHandler
    extends GuiTankGauge.ITankInfoHandler<IExtendedFluidTank> {
    }
}

