/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.FilterSelectButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.HashList;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.transporter.TransporterFilter;
import net.minecraft.util.text.ITextComponent;

public class MovableFilterButton
extends FilterButton {
    private final FilterSelectButton upButton;
    private final FilterSelectButton downButton;

    public MovableFilterButton(IGuiWrapper gui, int x, int y, int index, IntSupplier filterIndex, Supplier<HashList<? extends IFilter<?>>> filters, IntConsumer upButtonPress, IntConsumer downButtonPress, BiConsumer<IFilter<?>, Integer> onPress) {
        super(gui, x, y, 96, 29, index, filterIndex, filters, onPress);
        int arrowX = this.x + 96 - 12;
        this.upButton = new FilterSelectButton(gui, arrowX, this.y + 1, false, () -> upButtonPress.accept(index + filterIndex.getAsInt()), (onHover, xAxis, yAxis) -> this.displayTooltip((ITextComponent)MekanismLang.MOVE_UP.translate(new Object[0]), xAxis, yAxis));
        this.downButton = new FilterSelectButton(gui, arrowX, this.y + 21, true, () -> downButtonPress.accept(index + filterIndex.getAsInt()), (onHover, xAxis, yAxis) -> this.displayTooltip((ITextComponent)MekanismLang.MOVE_DOWN.translate(new Object[0]), xAxis, yAxis));
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        if (this.upButton.isMouseOver(mouseX, mouseY)) {
            this.upButton.onClick(mouseX, mouseY);
        } else if (this.downButton.isMouseOver(mouseX, mouseY)) {
            this.downButton.onClick(mouseX, mouseY);
        } else {
            super.onClick(mouseX, mouseY);
        }
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, int xAxis, int yAxis) {
        if (this.upButton.isMouseOver(mouseX, mouseY)) {
            this.upButton.renderToolTip(xAxis, yAxis);
        } else if (this.downButton.isMouseOver(mouseX, mouseY)) {
            this.downButton.renderToolTip(xAxis, yAxis);
        } else {
            super.renderForeground(mouseX, mouseY, xAxis, yAxis);
        }
        int x = this.x - this.guiObj.getLeft();
        int y = this.y - this.guiObj.getTop();
        IFilter filter = (IFilter)((HashList)this.filters.get()).getOrNull(this.filterIndex.getAsInt() + this.index);
        if (filter instanceof IItemStackFilter) {
            this.renderScaledText((ITextComponent)MekanismLang.ITEM_FILTER.translate(new Object[0]), x + 22, y + 2, 0x404040, 60);
        } else if (filter instanceof ITagFilter) {
            this.renderScaledText((ITextComponent)MekanismLang.TAG_FILTER.translate(new Object[0]), x + 22, y + 2, 0x404040, 60);
        } else if (filter instanceof IMaterialFilter) {
            this.renderScaledText((ITextComponent)MekanismLang.MATERIAL_FILTER.translate(new Object[0]), x + 22, y + 2, 0x404040, 60);
        } else if (filter instanceof IModIDFilter) {
            this.renderScaledText((ITextComponent)MekanismLang.MODID_FILTER.translate(new Object[0]), x + 22, y + 2, 0x404040, 60);
        }
        if (filter instanceof TransporterFilter) {
            TransporterFilter sorterFilter = (TransporterFilter)filter;
            this.drawString((ITextComponent)(sorterFilter.color == null ? MekanismLang.NONE.translate(new Object[0]) : sorterFilter.color.getColoredName()), x + 22, y + 11, 0x404040);
        }
    }

    @Override
    protected void setVisibility(boolean visible) {
        this.visible = visible;
        if (visible) {
            this.updateButtonVisibility();
        } else {
            this.upButton.visible = false;
            this.downButton.visible = false;
        }
    }

    private void updateButtonVisibility() {
        int index = this.filterIndex.getAsInt() + this.index;
        HashList filterList = (HashList)this.filters.get();
        IFilter filter = (IFilter)filterList.getOrNull(index);
        this.upButton.visible = filter != null && index > 0;
        this.downButton.visible = filter != null && index < filterList.size() - 1;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.visible) {
            this.updateButtonVisibility();
            this.upButton.render(mouseX, mouseY, partialTicks);
            this.downButton.render(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void colorButton() {
        IFilter filter = (IFilter)((HashList)this.filters.get()).getOrNull(this.filterIndex.getAsInt() + this.index);
        if (filter instanceof IItemStackFilter) {
            MekanismRenderer.color(EnumColor.INDIGO, 1.0f, 2.5f);
        } else if (filter instanceof ITagFilter) {
            MekanismRenderer.color(EnumColor.BRIGHT_GREEN, 1.0f, 2.5f);
        } else if (filter instanceof IMaterialFilter) {
            MekanismRenderer.color(EnumColor.PURPLE, 1.0f, 4.0f);
        } else if (filter instanceof IModIDFilter) {
            MekanismRenderer.color(EnumColor.PINK, 1.0f, 2.5f);
        }
    }
}

