/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Supplier;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiArrowSelection
extends GuiTexturedElement {
    private static final ResourceLocation ARROW = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "arrow_selection.png");
    private final Supplier<ITextComponent> textComponentSupplier;

    public GuiArrowSelection(IGuiWrapper gui, int x, int y, Supplier<ITextComponent> textComponentSupplier) {
        super(ARROW, gui, x, y, 33, 19);
        this.textComponentSupplier = textComponentSupplier;
    }

    public boolean isMouseOver(double xAxis, double yAxis) {
        return this.active && this.visible && xAxis >= (double)(this.x + 16) && xAxis < (double)(this.x + this.width - 1) && yAxis >= (double)(this.y + 1) && yAxis < (double)(this.y + this.height - 1);
    }

    public void renderToolTip(int mouseX, int mouseY) {
        ITextComponent component = this.textComponentSupplier.get();
        if (component != null) {
            int tooltipX = mouseX + 5;
            int tooltipY = mouseY - 5;
            GuiUtils.renderExtendedTexture(GuiInnerScreen.SCREEN, 2, 2, tooltipX - 3, tooltipY - 4, this.getStringWidth(component) + 6, 16);
            IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            MatrixStack matrix = new MatrixStack();
            matrix.func_227861_a_(0.0, 0.0, 300.0);
            this.getFontRenderer().func_228079_a_(component.func_150254_d(), (float)tooltipX, (float)tooltipY, 52480, false, matrix.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
            renderType.func_228461_a_();
        }
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        GuiArrowSelection.minecraft.field_71446_o.func_110577_a(this.getResource());
        GuiArrowSelection.blit((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
    }
}

