/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class GuiOredictionificator
extends GuiMekanismTile<TileEntityOredictionificator, MekanismTileContainer<TileEntityOredictionificator>> {
    private static final int FILTER_COUNT = 3;
    private Map<TileEntityOredictionificator.OredictionificatorFilter, ItemStack> renderStacks = new Object2ObjectOpenHashMap();
    private GuiScrollBar scrollBar;

    public GuiOredictionificator(MekanismTileContainer<TileEntityOredictionificator> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_147000_g += 64;
        this.dynamicSlots = true;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiElementHolder(this, 9, 17, 144, 68));
        this.addButton(new GuiElementHolder(this, 9, 85, 144, 22));
        this.scrollBar = new GuiScrollBar((IGuiWrapper)this, 153, 17, 90, () -> this.getFilters().size(), () -> 3);
        this.addButton(this.scrollBar);
        this.addButton(new GuiRedstoneControl(this, this.tile));
        this.addButton(new GuiSecurityTab<TileEntityMekanism>((IGuiWrapper)this, this.tile));
        this.addButton(new GuiProgress(() -> ((TileEntityOredictionificator)this.tile).didProcess ? 1.0 : 0.0, ProgressType.LARGE_RIGHT, this, 64, 119));
        this.addButton(new TranslationButton(this, this.getGuiLeft() + 10, this.getGuiTop() + 86, 142, 20, MekanismLang.BUTTON_NEW_FILTER, () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.OREDICTIONIFICATOR_FILTER, this.tile, -1))));
        for (int i = 0; i < 3; ++i) {
            this.addButton(new FilterButton((IGuiWrapper)this, 10, 18 + i * 22, 142, 22, i, this.scrollBar::getCurrentSelection, this::getFilters, this::onClick));
        }
    }

    protected HashList<TileEntityOredictionificator.OredictionificatorFilter> getFilters() {
        return ((TileEntityOredictionificator)this.tile).getFilters();
    }

    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof TileEntityOredictionificator.OredictionificatorFilter) {
            Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.OREDICTIONIFICATOR_FILTER, this.tile, index));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString(((TileEntityOredictionificator)this.tile).getName(), this.getXSize() / 2 - this.getStringWidth(((TileEntityOredictionificator)this.tile).getName()) / 2, 6, 0x404040);
        this.drawString((ITextComponent)MekanismLang.INVENTORY.translate(new Object[0]), 8, this.getYSize() - 96 + 2, 0x404040);
        HashList<TileEntityOredictionificator.OredictionificatorFilter> filters = this.getFilters();
        for (int i = 0; i < 3; ++i) {
            TileEntityOredictionificator.OredictionificatorFilter filter = filters.getOrNull(this.scrollBar.getCurrentSelection() + i);
            if (filter == null) continue;
            if (!this.renderStacks.containsKey(filter)) {
                this.updateRenderStacks();
            }
            int yStart = i * 22 + 18;
            this.renderItem(this.renderStacks.get(filter), 13, yStart + 3);
            this.drawString((ITextComponent)MekanismLang.FILTER.translate(new Object[0]), 32, yStart + 2, 0x404040);
            this.renderScaledText(filter.getFilterText(), 32, yStart + 2 + 9, 0x404040, 117);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        return this.scrollBar.adjustScroll(delta) || super.mouseScrolled(mouseX, mouseY, delta);
    }

    private void updateRenderStacks() {
        this.renderStacks.clear();
        for (TileEntityOredictionificator.OredictionificatorFilter filter : this.getFilters()) {
            this.renderStacks.put(filter, filter.getResult());
        }
    }
}

