/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.client.ClientPlayerTracker;
import mekanism.client.ClientTickHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.client.SparkleAnimation;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.sound.SoundHandler;
import mekanism.common.CommonProxy;
import mekanism.common.HolidayManager;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.network.NetworkEvent;

public class ClientProxy
extends CommonProxy {
    private void doSparkle(TileEntity tile, SparkleAnimation anim) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (tile.func_174877_v().func_177951_i((Vec3i)player.func_180425_c()) <= 400.0) {
            if (MekanismConfig.client.enableMultiblockFormationParticles.get()) {
                anim.run();
            } else {
                player.func_146105_b(MekanismLang.MULTIBLOCK_FORMED_CHAT.translateColored(EnumColor.INDIGO, new Object[0]), true);
            }
        }
    }

    @Override
    public void doMultiblockSparkle(TileEntity tile, BlockPos renderLoc, int length, int width, int height, SparkleAnimation.INodeChecker checker) {
        this.doSparkle(tile, new SparkleAnimation(tile, renderLoc, length, width, height, checker));
    }

    @Override
    public void doMultiblockSparkle(TileEntity tile, BlockPos corner1, BlockPos corner2, SparkleAnimation.INodeChecker checker) {
        this.doSparkle(tile, new SparkleAnimation(tile, corner1, corner2, checker));
    }

    @Override
    public void init() {
        super.init();
        MinecraftForge.EVENT_BUS.register((Object)new ClientPlayerTracker());
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RenderTickHandler());
        MinecraftForge.EVENT_BUS.register(SoundHandler.class);
        new MekanismKeyHandler();
        HolidayManager.init();
    }

    @Override
    public double getReach(PlayerEntity player) {
        return Minecraft.func_71410_x().field_71442_b == null ? 8.0 : (double)Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }

    @Override
    public boolean isPaused() {
        if (Minecraft.func_71410_x().func_71356_B() && !Minecraft.func_71410_x().func_71401_C().func_71344_c()) {
            return Minecraft.func_71410_x().func_147113_T();
        }
        return false;
    }

    @Override
    public PlayerEntity getPlayer(Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection().getReceptionSide().isServer()) {
            return super.getPlayer(context);
        }
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    @Nullable
    public World tryGetMainWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

