/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.transmitters;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.Range3D;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.INetworkDataHandler;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public abstract class DynamicNetwork<ACCEPTOR, NETWORK extends DynamicNetwork<ACCEPTOR, NETWORK, BUFFER>, BUFFER>
implements INetworkDataHandler,
IHasTextComponent {
    private static final Direction[] DIRECTIONS = Direction.values();
    protected Set<IGridTransmitter<ACCEPTOR, NETWORK, BUFFER>> transmitters = new ObjectLinkedOpenHashSet();
    protected Set<IGridTransmitter<ACCEPTOR, NETWORK, BUFFER>> transmittersToAdd = new ObjectOpenHashSet();
    protected Set<Coord4D> possibleAcceptors = new ObjectOpenHashSet();
    protected Map<Coord4D, EnumSet<Direction>> acceptorDirections = new Object2ObjectOpenHashMap();
    protected Map<IGridTransmitter<ACCEPTOR, NETWORK, BUFFER>, EnumSet<Direction>> changedAcceptors = new Object2ObjectOpenHashMap();
    protected Range3D packetRange = null;
    protected long capacity;
    protected boolean needsUpdate = false;
    protected boolean updateSaveShares;
    @Nullable
    protected World world = null;
    private boolean forceScaleUpdate = false;
    private final UUID uuid;

    public DynamicNetwork() {
        this(UUID.randomUUID());
    }

    public DynamicNetwork(UUID networkID) {
        this.uuid = networkID;
    }

    public void addNewTransmitters(Collection<IGridTransmitter<ACCEPTOR, NETWORK, BUFFER>> newTransmitters) {
        this.transmittersToAdd.addAll(newTransmitters);
        if (!this.forceScaleUpdate) {
            this.forceScaleUpdate = this.isEmpty();
        }
    }

    public void commit() {
        if (!this.transmittersToAdd.isEmpty()) {
            boolean addedValidTransmitters = false;
            for (IGridTransmitter<ACCEPTOR, DynamicNetwork, BUFFER> iGridTransmitter : this.transmittersToAdd) {
                if (iGridTransmitter == null || !iGridTransmitter.isValid()) continue;
                addedValidTransmitters = true;
                if (this.world == null) {
                    this.world = iGridTransmitter.world();
                }
                for (Direction side : DIRECTIONS) {
                    this.updateTransmitterOnSide(iGridTransmitter, side);
                }
                iGridTransmitter.setTransmitterNetwork(this);
                this.updateCapacity(iGridTransmitter);
                this.absorbBuffer(iGridTransmitter);
                this.transmitters.add(iGridTransmitter);
            }
            this.transmittersToAdd.clear();
            if (addedValidTransmitters) {
                this.clampBuffer();
                this.updateSaveShares = true;
                if (this.forceScaleUpdate) {
                    this.forceScaleUpdate = false;
                    this.forceScaleUpdate();
                }
                this.needsUpdate = true;
            }
        }
        if (!this.changedAcceptors.isEmpty()) {
            for (Map.Entry<IGridTransmitter<ACCEPTOR, NETWORK, BUFFER>, EnumSet<Direction>> entry : this.changedAcceptors.entrySet()) {
                IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> iGridTransmitter = entry.getKey();
                if (!iGridTransmitter.isValid()) continue;
                for (Direction side : entry.getValue()) {
                    this.updateTransmitterOnSide(iGridTransmitter, side);
                }
            }
            this.changedAcceptors.clear();
        }
    }

    public void updateTransmitterOnSide(IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> transmitter, Direction side) {
        ACCEPTOR acceptor = transmitter.getAcceptor(side);
        Coord4D acceptorCoord = transmitter.coord().offset(side);
        EnumSet<Direction> directions = this.acceptorDirections.get(acceptorCoord);
        if (acceptor != null) {
            this.possibleAcceptors.add(acceptorCoord);
            if (directions != null) {
                directions.add(side.func_176734_d());
            } else {
                this.acceptorDirections.put(acceptorCoord, EnumSet.of(side.func_176734_d()));
            }
        } else if (directions != null) {
            directions.remove(side.func_176734_d());
            if (directions.isEmpty()) {
                this.possibleAcceptors.remove(acceptorCoord);
                this.acceptorDirections.remove(acceptorCoord);
            }
        } else {
            this.possibleAcceptors.remove(acceptorCoord);
            this.acceptorDirections.remove(acceptorCoord);
        }
    }

    @Nullable
    public BUFFER getBuffer() {
        return null;
    }

    public boolean isRemote() {
        return this.world == null ? EffectiveSide.get().isClient() : this.world.field_72995_K;
    }

    public abstract void absorbBuffer(IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> var1);

    public abstract void clampBuffer();

    protected void forceScaleUpdate() {
    }

    public void invalidate() {
        this.transmitters.removeIf(transmitter -> !transmitter.isValid());
        this.clampBuffer();
        this.updateSaveShares();
        for (IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> transmitter2 : this.transmitters) {
            this.invalidateTransmitter(transmitter2);
        }
        this.transmitters.clear();
        this.deregister();
    }

    public void invalidateTransmitter(IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> transmitter) {
        if (!this.isRemote() && transmitter.isValid()) {
            transmitter.takeShare();
            transmitter.setTransmitterNetwork(null);
            TransmitterNetworkRegistry.registerOrphanTransmitter(transmitter);
        }
    }

    public void acceptorChanged(IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> transmitter, Direction side) {
        EnumSet<Direction> directions = this.changedAcceptors.get(transmitter);
        if (directions == null) {
            this.changedAcceptors.put(transmitter, EnumSet.of(side));
        } else {
            directions.add(side);
        }
        TransmitterNetworkRegistry.registerChangedNetwork(this);
    }

    public void adoptTransmittersAndAcceptorsFrom(NETWORK net) {
        for (IGridTransmitter<ACCEPTOR, DynamicNetwork, BUFFER> iGridTransmitter : ((DynamicNetwork)net).transmitters) {
            iGridTransmitter.setTransmitterNetwork(this);
            this.transmitters.add(iGridTransmitter);
        }
        this.transmittersToAdd.addAll(((DynamicNetwork)net).transmittersToAdd);
        this.possibleAcceptors.addAll(((DynamicNetwork)net).possibleAcceptors);
        for (Map.Entry entry : ((DynamicNetwork)net).acceptorDirections.entrySet()) {
            Coord4D coord = (Coord4D)entry.getKey();
            if (this.acceptorDirections.containsKey(coord)) {
                this.acceptorDirections.get(coord).addAll((Collection)entry.getValue());
                continue;
            }
            this.acceptorDirections.put(coord, (EnumSet<Direction>)entry.getValue());
        }
        this.updateCapacity();
    }

    public Range3D getPacketRange() {
        return this.packetRange == null ? this.genPacketRange() : this.packetRange;
    }

    private Range3D genPacketRange() {
        if (this.isEmpty()) {
            this.deregister();
            return null;
        }
        IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> initTransmitter = this.firstTransmitter();
        Coord4D initCoord = initTransmitter.coord();
        int minX = initCoord.x;
        int minZ = initCoord.z;
        int maxX = initCoord.x;
        int maxZ = initCoord.z;
        for (IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> transmitter : this.transmitters) {
            Coord4D coord = transmitter.coord();
            if (coord.x < minX) {
                minX = coord.x;
            } else if (coord.x > maxX) {
                maxX = coord.x;
            }
            if (coord.z < minZ) {
                minZ = coord.z;
                continue;
            }
            if (coord.z <= maxZ) continue;
            maxZ = coord.z;
        }
        return new Range3D(minX, minZ, maxX, maxZ, initTransmitter.world().func_201675_m().func_186058_p());
    }

    public void register() {
        if (this.isRemote()) {
            TransmitterNetworkRegistry.getInstance().addClientNetwork(this.getUUID(), this);
        } else {
            TransmitterNetworkRegistry.getInstance().registerNetwork(this);
        }
    }

    public void deregister() {
        this.transmitters.clear();
        this.transmittersToAdd.clear();
        if (this.isRemote()) {
            TransmitterNetworkRegistry.getInstance().removeClientNetwork(this);
        } else {
            TransmitterNetworkRegistry.getInstance().removeNetwork(this);
        }
    }

    public boolean isEmpty() {
        return this.transmitters.isEmpty();
    }

    public int getAcceptorSize() {
        return this.possibleAcceptors.size();
    }

    protected synchronized void updateCapacity(IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> transmitter) {
        long transmitterCapacity = transmitter.getCapacity();
        this.capacity = transmitterCapacity > Long.MAX_VALUE - this.capacity ? Long.MAX_VALUE : (this.capacity += transmitterCapacity);
    }

    public synchronized void updateCapacity() {
        long sum = 0L;
        for (IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> transmitter : this.transmitters) {
            long transmitterCapacity = transmitter.getCapacity();
            if (transmitterCapacity > Long.MAX_VALUE - this.capacity) {
                sum = Long.MAX_VALUE;
                break;
            }
            sum += transmitterCapacity;
        }
        if (this.capacity != sum) {
            this.capacity = sum;
            this.updateSaveShares = true;
        }
    }

    public long getCapacity() {
        return this.capacity;
    }

    @Nullable
    public World getWorld() {
        return this.world;
    }

    public void tick() {
        this.onUpdate();
    }

    public void onUpdate() {
        if (!this.isRemote() && this.updateSaveShares) {
            this.updateSaveShares();
        }
    }

    protected void updateSaveShares() {
        this.updateSaveShares = false;
    }

    public boolean isCompatibleWith(NETWORK other) {
        return true;
    }

    public boolean compatibleWithBuffer(BUFFER buffer) {
        return true;
    }

    public Set<IGridTransmitter<ACCEPTOR, NETWORK, BUFFER>> getTransmitters() {
        return this.transmitters;
    }

    public boolean addTransmitter(IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> transmitter) {
        return this.transmitters.add(transmitter);
    }

    public boolean removeTransmitter(IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> transmitter) {
        boolean removed = this.transmitters.remove(transmitter);
        if (this.transmitters.isEmpty()) {
            this.deregister();
        }
        return removed;
    }

    public IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> firstTransmitter() {
        return this.transmitters.iterator().next();
    }

    public int transmittersSize() {
        return this.transmitters.size();
    }

    public Set<IGridTransmitter<ACCEPTOR, NETWORK, BUFFER>> getTransmittersToAdd() {
        return this.transmittersToAdd;
    }

    public Set<Coord4D> getPossibleAcceptors() {
        return this.possibleAcceptors;
    }

    public Map<Coord4D, EnumSet<Direction>> getAcceptorDirections() {
        return this.acceptorDirections;
    }

    public Map<IGridTransmitter<ACCEPTOR, NETWORK, BUFFER>, EnumSet<Direction>> getChangedAcceptors() {
        return this.changedAcceptors;
    }

    public UUID getUUID() {
        return this.uuid;
    }
}

