/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.tier;

import java.util.Locale;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import net.minecraft.util.IStringSerializable;

public enum BaseTier implements IStringSerializable
{
    BASIC("Basic", EnumColor.BRIGHT_GREEN),
    ADVANCED("Advanced", EnumColor.DARK_RED),
    ELITE("Elite", EnumColor.DARK_BLUE),
    ULTIMATE("Ultimate", EnumColor.PURPLE),
    CREATIVE("Creative", EnumColor.BLACK);

    private static final BaseTier[] TIERS;
    private final String name;
    private final EnumColor color;

    private BaseTier(String s, EnumColor c) {
        this.name = s;
        this.color = c;
    }

    public String getSimpleName() {
        return this.name;
    }

    public String getLowerName() {
        return this.getSimpleName().toLowerCase(Locale.ROOT);
    }

    public EnumColor getColor() {
        return this.color;
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static BaseTier byIndexStatic(int index) {
        return MathUtils.getByIndexMod(TIERS, index);
    }

    static {
        TIERS = BaseTier.values();
    }
}

