/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.inputs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.GasTags;
import mekanism.api.providers.IGasProvider;
import mekanism.api.recipes.inputs.InputIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public abstract class GasStackIngredient
implements InputIngredient<GasStack> {
    public static GasStackIngredient from(@Nonnull GasStack instance) {
        return GasStackIngredient.from((IGasProvider)instance.getType(), instance.getAmount());
    }

    public static GasStackIngredient from(@Nonnull IGasProvider instance, long amount) {
        return new Single(instance.getGasStack(amount));
    }

    public static GasStackIngredient from(@Nonnull Tag<Gas> gasTag, long amount) {
        return new Tagged(gasTag, amount);
    }

    @Override
    public abstract boolean testType(@Nonnull Gas var1);

    public static GasStackIngredient read(PacketBuffer buffer) {
        IngredientType type = (IngredientType)buffer.func_179257_a(IngredientType.class);
        if (type == IngredientType.SINGLE) {
            return Single.read(buffer);
        }
        if (type == IngredientType.TAGGED) {
            return Tagged.read(buffer);
        }
        return Multi.read(buffer);
    }

    public static GasStackIngredient deserialize(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Ingredient cannot be null");
        }
        if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            int size = jsonArray.size();
            if (size == 0) {
                throw new JsonSyntaxException("Ingredient array cannot be empty, at least one ingredient must be defined");
            }
            if (size > 1) {
                GasStackIngredient[] ingredients = new GasStackIngredient[size];
                for (int i = 0; i < size; ++i) {
                    ingredients[i] = GasStackIngredient.deserialize(jsonArray.get(i));
                }
                return GasStackIngredient.createMulti(ingredients);
            }
            json = jsonArray.get(0);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has("gas") && jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (jsonObject.has("gas")) {
            return GasStackIngredient.from(SerializerHelper.deserializeGas(jsonObject));
        }
        if (jsonObject.has("tag")) {
            if (!jsonObject.has("amount")) {
                throw new JsonSyntaxException("Expected to receive a amount that is greater than zero");
            }
            JsonElement count = jsonObject.get("amount");
            if (!JSONUtils.func_188175_b((JsonElement)count)) {
                throw new JsonSyntaxException("Expected amount to be a number greater than zero.");
            }
            long amount = count.getAsJsonPrimitive().getAsLong();
            if (amount < 1L) {
                throw new JsonSyntaxException("Expected amount to be greater than zero.");
            }
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
            Tag tag = GasTags.getCollection().func_199910_a(resourceLocation);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown gas tag '" + resourceLocation + "'");
            }
            return GasStackIngredient.from((Tag<Gas>)tag, amount);
        }
        throw new JsonSyntaxException("Expected to receive a resource location representing either a tag or a gas.");
    }

    public static GasStackIngredient createMulti(GasStackIngredient ... ingredients) {
        if (ingredients.length != 0 && ingredients.length == 1) {
            return ingredients[0];
        }
        ArrayList<GasStackIngredient> cleanedIngredients = new ArrayList<GasStackIngredient>();
        for (GasStackIngredient ingredient : ingredients) {
            if (ingredient instanceof Multi) {
                cleanedIngredients.addAll(Arrays.asList(((Multi)ingredient).ingredients));
                continue;
            }
            cleanedIngredients.add(ingredient);
        }
        return new Multi(cleanedIngredients.toArray(new GasStackIngredient[0]));
    }

    private static enum IngredientType {
        SINGLE,
        TAGGED,
        MULTI;

    }

    public static class Multi
    extends GasStackIngredient {
        private final GasStackIngredient[] ingredients;

        protected Multi(GasStackIngredient ... ingredients) {
            this.ingredients = ingredients;
        }

        @Override
        public boolean test(@Nonnull GasStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public boolean testType(@Nonnull GasStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(stack));
        }

        @Override
        public boolean testType(@Nonnull Gas gas) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(gas));
        }

        @Override
        @Nonnull
        public GasStack getMatchingInstance(@Nonnull GasStack stack) {
            for (GasStackIngredient ingredient : this.ingredients) {
                GasStack matchingInstance = ingredient.getMatchingInstance(stack);
                if (matchingInstance.isEmpty()) continue;
                return matchingInstance;
            }
            return GasStack.EMPTY;
        }

        @Override
        @Nonnull
        public List<@NonNull GasStack> getRepresentations() {
            ArrayList<@NonNull GasStack> representations = new ArrayList<GasStack>();
            for (GasStackIngredient ingredient : this.ingredients) {
                representations.addAll(ingredient.getRepresentations());
            }
            return representations;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)IngredientType.MULTI);
            buffer.func_150787_b(this.ingredients.length);
            for (GasStackIngredient ingredient : this.ingredients) {
                ingredient.write(buffer);
            }
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonArray json = new JsonArray();
            for (GasStackIngredient ingredient : this.ingredients) {
                json.add(ingredient.serialize());
            }
            return json;
        }

        public static GasStackIngredient read(PacketBuffer buffer) {
            GasStackIngredient[] ingredients = new GasStackIngredient[buffer.func_150792_a()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = GasStackIngredient.read(buffer);
            }
            return Multi.createMulti(ingredients);
        }
    }

    public static class Tagged
    extends GasStackIngredient {
        @Nonnull
        private final Tag<Gas> tag;
        private final long amount;

        public Tagged(@Nonnull Tag<Gas> tag, long amount) {
            this.tag = tag;
            this.amount = amount;
        }

        @Override
        public boolean test(@Nonnull GasStack gasStack) {
            return this.testType(gasStack) && gasStack.getAmount() >= this.amount;
        }

        @Override
        public boolean testType(@Nonnull GasStack gasStack) {
            return this.testType((Gas)Objects.requireNonNull(gasStack).getType());
        }

        @Override
        public boolean testType(@Nonnull Gas gas) {
            return Objects.requireNonNull(gas).isIn(this.tag);
        }

        @Override
        @Nonnull
        public GasStack getMatchingInstance(@Nonnull GasStack gasStack) {
            if (this.test(gasStack)) {
                return new GasStack(gasStack, this.amount);
            }
            return GasStack.EMPTY;
        }

        @Override
        @Nonnull
        public List<@NonNull GasStack> getRepresentations() {
            ArrayList<@NonNull GasStack> representations = new ArrayList<GasStack>();
            for (Gas gas : this.tag.func_199885_a()) {
                representations.add(new GasStack(gas, this.amount));
            }
            return representations;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)IngredientType.TAGGED);
            buffer.func_192572_a(this.tag.func_199886_b());
            buffer.func_179254_b(this.amount);
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("amount", (Number)this.amount);
            json.addProperty("tag", this.tag.func_199886_b().toString());
            return json;
        }

        public static Tagged read(PacketBuffer buffer) {
            return new Tagged(new GasTags.Wrapper(buffer.func_192575_l()), buffer.func_179260_f());
        }
    }

    public static class Single
    extends GasStackIngredient {
        @Nonnull
        private final GasStack gasInstance;

        protected Single(@Nonnull GasStack gasInstance) {
            this.gasInstance = Objects.requireNonNull(gasInstance);
        }

        @Override
        public boolean test(@Nonnull GasStack gasStack) {
            return this.testType(gasStack) && gasStack.getAmount() >= this.gasInstance.getAmount();
        }

        @Override
        public boolean testType(@Nonnull GasStack gasStack) {
            return this.gasInstance.isTypeEqual((ChemicalStack)Objects.requireNonNull(gasStack));
        }

        @Override
        public boolean testType(@Nonnull Gas gas) {
            return this.gasInstance.isTypeEqual((Chemical)Objects.requireNonNull(gas));
        }

        @Override
        @Nonnull
        public GasStack getMatchingInstance(@Nonnull GasStack gasStack) {
            return this.test(gasStack) ? this.gasInstance.copy() : GasStack.EMPTY;
        }

        @Override
        @Nonnull
        public List<@NonNull GasStack> getRepresentations() {
            return Collections.singletonList(this.gasInstance);
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)IngredientType.SINGLE);
            this.gasInstance.writeToPacket(buffer);
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("amount", (Number)this.gasInstance.getAmount());
            json.addProperty("gas", this.gasInstance.getTypeRegistryName().toString());
            return json;
        }

        public static Single read(PacketBuffer buffer) {
            return new Single(GasStack.readFromPacket(buffer));
        }
    }
}

