/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.fluid;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.fluid.ExtendedFluidHandlerUtils;
import mekanism.api.fluid.IExtendedFluidHandler;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface ISidedFluidHandler
extends IExtendedFluidHandler {
    @Nullable
    default public Direction getFluidSideFor() {
        return null;
    }

    public int getTanks(@Nullable Direction var1);

    default public int getTanks() {
        return this.getTanks(this.getFluidSideFor());
    }

    public FluidStack getFluidInTank(int var1, @Nullable Direction var2);

    default public FluidStack getFluidInTank(int tank) {
        return this.getFluidInTank(tank, this.getFluidSideFor());
    }

    public void setFluidInTank(int var1, FluidStack var2, @Nullable Direction var3);

    @Override
    default public void setFluidInTank(int tank, FluidStack stack) {
        this.setFluidInTank(tank, stack, this.getFluidSideFor());
    }

    public int getTankCapacity(int var1, @Nullable Direction var2);

    default public int getTankCapacity(int tank) {
        return this.getTankCapacity(tank, this.getFluidSideFor());
    }

    public boolean isFluidValid(int var1, FluidStack var2, @Nullable Direction var3);

    default public boolean isFluidValid(int tank, FluidStack stack) {
        return this.isFluidValid(tank, stack, this.getFluidSideFor());
    }

    public FluidStack insertFluid(int var1, FluidStack var2, @Nullable Direction var3, Action var4);

    @Override
    default public FluidStack insertFluid(int tank, FluidStack stack, Action action) {
        return this.insertFluid(tank, stack, this.getFluidSideFor(), action);
    }

    public FluidStack extractFluid(int var1, int var2, @Nullable Direction var3, Action var4);

    @Override
    default public FluidStack extractFluid(int tank, int amount, Action action) {
        return this.extractFluid(tank, amount, this.getFluidSideFor(), action);
    }

    default public FluidStack insertFluid(FluidStack stack, @Nullable Direction side, Action action) {
        return ExtendedFluidHandlerUtils.insert(stack, action, () -> this.getTanks(side), (Int2ObjectFunction<FluidStack>)((Int2ObjectFunction)tank -> this.getFluidInTank(tank, side)), (tank, s, a) -> this.insertFluid(tank, s, side, a));
    }

    default public FluidStack extractFluid(int amount, @Nullable Direction side, Action action) {
        return ExtendedFluidHandlerUtils.extract(amount, action, () -> this.getTanks(side), (Int2ObjectFunction<FluidStack>)((Int2ObjectFunction)tank -> this.getFluidInTank(tank, side)), (tank, a, act) -> this.extractFluid(tank, a, side, act));
    }

    default public FluidStack extractFluid(FluidStack stack, @Nullable Direction side, Action action) {
        return ExtendedFluidHandlerUtils.extract(stack, action, () -> this.getTanks(side), (Int2ObjectFunction<FluidStack>)((Int2ObjectFunction)tank -> this.getFluidInTank(tank, side)), (tank, a, act) -> this.extractFluid(tank, a, side, act));
    }
}

