/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.gas;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.ISidedGasHandler;
import mekanism.api.inventory.AutomationType;
import net.minecraft.util.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IMekanismGasHandler
extends ISidedGasHandler {
    default public boolean canHandleGas() {
        return true;
    }

    public List<IGasTank> getGasTanks(@Nullable Direction var1);

    public void onContentsChanged();

    @Nullable
    default public IGasTank getGasTank(int tank, @Nullable Direction side) {
        List<IGasTank> tanks = this.getGasTanks(side);
        return tank >= 0 && tank < tanks.size() ? tanks.get(tank) : null;
    }

    @Override
    default public int getGasTankCount(@Nullable Direction side) {
        return this.getGasTanks(side).size();
    }

    @Override
    default public GasStack getGasInTank(int tank, @Nullable Direction side) {
        IGasTank gasTank = this.getGasTank(tank, side);
        return gasTank == null ? GasStack.EMPTY : (GasStack)gasTank.getStack();
    }

    @Override
    default public void setGasInTank(int tank, GasStack stack, @Nullable Direction side) {
        IGasTank gasTank = this.getGasTank(tank, side);
        if (gasTank != null) {
            gasTank.setStack(stack);
        }
    }

    @Override
    default public long getGasTankCapacity(int tank, @Nullable Direction side) {
        IGasTank gasTank = this.getGasTank(tank, side);
        return gasTank == null ? 0L : gasTank.getCapacity();
    }

    @Override
    default public boolean isGasValid(int tank, GasStack stack, @Nullable Direction side) {
        IGasTank gasTank = this.getGasTank(tank, side);
        return gasTank != null && gasTank.isValid(stack);
    }

    @Override
    default public GasStack insertGas(int tank, GasStack stack, @Nullable Direction side, Action action) {
        IGasTank gasTank = this.getGasTank(tank, side);
        return gasTank == null ? stack : gasTank.insert(stack, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
    }

    @Override
    default public GasStack extractGas(int tank, long amount, @Nullable Direction side, Action action) {
        IGasTank gasTank = this.getGasTank(tank, side);
        return gasTank == null ? GasStack.EMPTY : (GasStack)gasTank.extract(amount, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
    }
}

