/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.gas;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.gas.GasBuilder;
import mekanism.api.chemical.gas.GasTags;
import mekanism.api.providers.IGasProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.common.util.ReverseTagWrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Gas
extends Chemical<Gas>
implements IGasProvider {
    private final ReverseTagWrapper<Gas> reverseTags = new ReverseTagWrapper((Object)this, GasTags::getGeneration, GasTags::getCollection);
    private boolean hidden;

    public Gas(GasBuilder builder) {
        super(builder);
        this.hidden = builder.isHidden();
    }

    public static Gas readFromNBT(@Nullable CompoundNBT nbtTags) {
        if (nbtTags == null || nbtTags.isEmpty()) {
            return MekanismAPI.EMPTY_GAS;
        }
        return Gas.getFromRegistry(new ResourceLocation(nbtTags.func_74779_i("gasName")));
    }

    public static Gas getFromRegistry(@Nullable ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return MekanismAPI.EMPTY_GAS;
        }
        Gas gas = (Gas)MekanismAPI.GAS_REGISTRY.getValue(resourceLocation);
        if (gas == null) {
            return MekanismAPI.EMPTY_GAS;
        }
        return gas;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        nbtTags.func_74778_a("gasName", this.getRegistryName().toString());
        return nbtTags;
    }

    @Override
    public Gas getGas() {
        return this;
    }

    public String toString() {
        return "[Gas: " + this.getRegistryName() + "]";
    }

    @Override
    public boolean isIn(@Nonnull Tag<Gas> tag) {
        return tag.func_199685_a_((Object)this);
    }

    @Override
    public Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    @Override
    public final boolean isEmptyType() {
        return this == MekanismAPI.EMPTY_GAS;
    }

    @Override
    protected String getDefaultTranslationKey() {
        return Util.func_200697_a((String)"gas", (ResourceLocation)this.getRegistryName());
    }
}

