/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.yogpc.qp.QuarryPlus;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class RecipeGetter {
    private static final Method getRecipes;

    public static <T extends IRecipe<?>> Map<ResourceLocation, T> getRecipes(RecipeManager manager, IRecipeType<T> recipeTypeIn) {
        if (getRecipes == null) {
            return Collections.emptyMap();
        }
        try {
            Map invoke = (Map)getRecipes.invoke((Object)manager, recipeTypeIn);
            return invoke;
        }
        catch (ReflectiveOperationException e) {
            QuarryPlus.LOGGER.error("Error in getting recipe of " + recipeTypeIn + ".", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    static {
        Method getRecipesMethod;
        try {
            getRecipesMethod = ObfuscationReflectionHelper.findMethod(RecipeManager.class, (String)"func_215366_a", (Class[])new Class[]{IRecipeType.class});
        }
        catch (Exception e) {
            e.printStackTrace();
            getRecipesMethod = null;
        }
        getRecipes = getRecipesMethod;
    }
}

