/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.quarry;

import com.yogpc.qp.Config;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class MoveHead
implements IMessage<MoveHead> {
    int dim;
    BlockPos pos;
    double headPosX;
    double headPosY;
    double headPosZ;

    public static MoveHead create(TileQuarry quarry) {
        MoveHead message = new MoveHead();
        message.dim = IMessage.getDimId(quarry.func_145831_w());
        message.pos = quarry.func_174877_v();
        message.headPosX = quarry.headPosX;
        message.headPosY = quarry.headPosY;
        message.headPosZ = quarry.headPosZ;
        return message;
    }

    public static void send(TileQuarry quarry) {
        PacketHandler.sendToAround(MoveHead.create(quarry), Objects.requireNonNull(quarry.func_145831_w()), quarry.func_174877_v());
    }

    @Override
    public MoveHead readFromBuffer(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.headPosX = buffer.readDouble();
        this.headPosY = buffer.readDouble();
        this.headPosZ = buffer.readDouble();
        return this;
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim);
        buffer.writeDouble(this.headPosX).writeDouble(this.headPosY).writeDouble(this.headPosZ);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        if (((Boolean)Config.client().enableRender().get()).booleanValue()) {
            IMessage.findTile(ctx, this.pos, this.dim, TileQuarry.class).ifPresent(quarry -> {
                quarry.headPosX = this.headPosX;
                quarry.headPosY = this.headPosY;
                quarry.headPosZ = this.headPosZ;
            });
        }
    }
}

