/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.replacer;

import com.yogpc.qp.machines.base.APacketTile;
import com.yogpc.qp.machines.base.IAttachable;
import com.yogpc.qp.machines.base.IAttachment;
import com.yogpc.qp.machines.base.IDebugSender;
import com.yogpc.qp.machines.base.IModule;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.pump.TilePump;
import com.yogpc.qp.machines.replacer.ReplacerModule;
import com.yogpc.qp.utils.Holder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import org.apache.commons.lang3.tuple.Pair;
import scala.Symbol;

public class TileReplacer
extends APacketTile
implements IAttachment,
IDebugSender,
ITickableTileEntity {
    public static final Symbol SYMBOL = Symbol.apply((String)"Replacer");
    private static final List<Predicate<BlockState>> rejects = new ArrayList<Predicate>(Arrays.asList(state -> state.func_177230_c().hasTileEntity(state), state -> state.func_185904_a() == Material.field_151594_q, TilePump::isLiquid, MapStreamSyntax.always_false()));
    private Direction facing;
    private boolean loading = false;
    private final ReplacerModule module = ReplacerModule.apply(this);

    public TileReplacer() {
        super(Holder.replacerType());
    }

    public void neighborChanged() {
        this.connection();
    }

    public void onPlaced() {
        this.connection();
    }

    private void connection() {
        if (this.func_145830_o() && !Objects.requireNonNull(this.field_145850_b).field_72995_K && this.enabled()) {
            Map.Entry<Direction, IAttachable> entry = Stream.of(Direction.values()).map(f -> Pair.of((Object)f, (Object)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f)))).filter(MapStreamSyntax.byValue(IAttachable.class::isInstance)).map(MapStreamSyntax.values(IAttachable.class::cast)).filter(MapStreamSyntax.byEntry((facing, t) -> t.connect(facing.func_176734_d(), IAttachment.Attachments.REPLACER))).findFirst().orElse((Map.Entry<Direction, IAttachable>)Pair.of(null, (Object)IAttachable.dummy));
            if (entry.getKey() == null || entry.getValue().connectAttachment(entry.getKey().func_176734_d(), IAttachment.Attachments.REPLACER, false)) {
                this.setConnectTo(entry.getKey());
            }
        }
    }

    @Override
    public void setConnectTo(@Nullable Direction facing) {
        BlockState state;
        this.facing = facing;
        if (this.func_145830_o() && facing != null ^ (Boolean)(state = Objects.requireNonNull(this.field_145850_b).func_180495_p(this.func_174877_v())).func_177229_b((IProperty)QPBlock.WORKING())) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(facing != null)));
        }
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.facing = Optional.of(compound.func_74779_i("facing")).filter(MapStreamSyntax.not(String::isEmpty)).map(Direction::func_176739_a).orElse(null);
        this.loading = true;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74778_a("facing", Optional.ofNullable(this.facing).map(Enum::name).orElse(""));
        return super.func_189515_b(compound);
    }

    public BlockState getReplaceState() {
        Predicate accept = rejects.stream().reduce(MapStreamSyntax.always_false(), Predicate::or).negate();
        return Optional.ofNullable(this.field_145850_b).map(world -> world.func_180495_p(this.field_174879_c.func_177984_a())).filter(s -> !s.isAir((IBlockReader)this.field_145850_b, this.field_174879_c.func_177984_a())).filter(accept).orElse(Holder.blockDummy().func_176223_P());
    }

    @Override
    public String getDebugName() {
        return "block.quarryplus.quarryreplacer";
    }

    @Override
    public List<? extends ITextComponent> getDebugMessages() {
        return Stream.of("Connect: " + this.facing, "toReplaceState: " + this.getReplaceState(), "Module: " + this.module).map(StringTextComponent::new).collect(Collectors.toList());
    }

    public void func_73660_a() {
        if (this.loading) {
            this.loading = false;
            this.connection();
        }
    }
}

