/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public interface IMarker {
    public static final IMarker EMPTY_MARKER = new MarkerImpl(BlockPos.field_177992_a, BlockPos.field_177992_a);

    public boolean hasLink();

    public BlockPos min();

    public BlockPos max();

    public List<ItemStack> removeFromWorldWithItem();

    public static class MarkerImpl
    implements IMarker {
        private final BlockPos min;
        private final BlockPos max;

        public MarkerImpl(BlockPos min, BlockPos max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean hasLink() {
            return true;
        }

        @Override
        public BlockPos min() {
            return this.min;
        }

        @Override
        public BlockPos max() {
            return this.max;
        }

        @Override
        public List<ItemStack> removeFromWorldWithItem() {
            return Collections.emptyList();
        }
    }

    public static final class Cap
    implements Capability.IStorage<IMarker>,
    Callable<IMarker> {
        @CapabilityInject(value=IMarker.class)
        public static final Capability<IMarker> MARKER_CAP = null;

        @Override
        public IMarker call() {
            return EMPTY_MARKER;
        }

        public INBT writeNBT(Capability<IMarker> capability, IMarker instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74772_a("min", instance.min().func_218275_a());
            nbt.func_74772_a("max", instance.max().func_218275_a());
            return nbt;
        }

        public void readNBT(Capability<IMarker> capability, IMarker instance, Direction side, INBT nbt) {
        }

        public static Capability<IMarker> MARKER_CAPABILITY() {
            return MARKER_CAP;
        }

        public static void register() {
            Cap cap = new Cap();
            CapabilityManager.INSTANCE.register(IMarker.class, (Capability.IStorage)cap, (Callable)cap);
        }
    }
}

