/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.compat.jei;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.lib.util.TextRenderUtils;
import net.silentchaos512.mechanisms.block.crusher.CrusherScreen;
import net.silentchaos512.mechanisms.crafting.recipe.CrushingRecipe;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.util.Constants;
import net.silentchaos512.mechanisms.util.TextUtil;

public class CrushingRecipeCategoryJei
implements IRecipeCategory<CrushingRecipe> {
    private static final int GUI_START_X = 25;
    private static final int GUI_START_Y = 34;
    private static final int GUI_WIDTH = 126;
    private static final int GUI_HEIGHT = 26;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final String localizedName;

    public CrushingRecipeCategoryJei(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(CrusherScreen.TEXTURE, 25, 34, 126, 26);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.crusher));
        this.arrow = guiHelper.drawableBuilder(CrusherScreen.TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = TextUtil.translate("jei", "category.crushing", new Object[0]).func_150254_d();
    }

    public ResourceLocation getUid() {
        return Constants.CRUSHING;
    }

    public Class<? extends CrushingRecipe> getRecipeClass() {
        return CrushingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CrushingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(Collections.singletonList(recipe.getIngredient()));
        ingredients.setOutputs(VanillaTypes.ITEM, new ArrayList<ItemStack>(recipe.getPossibleResults((IInventory)new Inventory(5))));
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrushingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 0, 0);
        itemStacks.init(1, false, 54, 0);
        itemStacks.init(2, false, 72, 0);
        itemStacks.init(3, false, 90, 0);
        itemStacks.init(4, false, 108, 0);
        itemStacks.set(0, Arrays.asList(recipe.getIngredient().func_193365_a()));
        List<Pair<ItemStack, Float>> results = recipe.getPossibleResultsWithChances();
        for (int i = 0; i < results.size(); ++i) {
            itemStacks.set(i + 1, (ItemStack)results.get(i).getFirst());
        }
    }

    public void draw(CrushingRecipe recipe, double mouseX, double mouseY) {
        this.arrow.draw(24, 1);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        List<Pair<ItemStack, Float>> results = recipe.getPossibleResultsWithChances();
        for (int i = 0; i < results.size(); ++i) {
            float chance = ((Float)results.get(i).getSecond()).floatValue();
            if (!(chance < 1.0f)) continue;
            int asPercent = (int)(100.0f * chance);
            String text = asPercent < 1 ? "<1%" : asPercent + "%";
            TextRenderUtils.renderScaled((FontRenderer)font, (String)text, (int)(57 + 18 * i), (int)20, (float)0.75f, (int)0xFFFFFF, (boolean)true);
        }
    }
}

